/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.SchemaUtil;
import com.weibo.breeze.message.Schema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.file.FileURLConnection;

public class SchemaLoader {
    public static final String PATH = "META-INF/breeze/";
    public static final String SUFFIX = ".breeze";
    private static final Logger logger = LoggerFactory.getLogger(SchemaLoader.class);
    private static final Schema noSchema = Schema.newSchema("noSchema");
    private static Map<String, Schema> schemas = new ConcurrentHashMap<String, Schema>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema loadSchema(String className) {
        Schema schema = schemas.get(className = Breeze.getCleanName(className));
        if (schema == null) {
            String string = className.intern();
            synchronized (string) {
                schema = schemas.get(className);
                if (schema == null) {
                    try {
                        InputStream inputStream = SchemaLoader.class.getResourceAsStream("/META-INF/breeze/" + className + SUFFIX);
                        if (inputStream != null) {
                            schema = SchemaUtil.parseSchema(SchemaLoader.readContentAndClose(inputStream));
                        }
                    }
                    catch (Exception e) {
                        logger.warn("read breeze schema fail. class:" + className + ", error:" + e.getMessage());
                    }
                    if (schema == null) {
                        schema = noSchema;
                    } else {
                        logger.info("read breeze schema success for class: " + className);
                    }
                    schemas.put(className, schema);
                }
            }
        }
        if (schema == noSchema) {
            schema = null;
        }
        return schema;
    }

    public static boolean loadAllSchema() {
        try {
            Enumeration<URL> enumeration = SchemaLoader.class.getClassLoader().getResources(PATH);
            while (enumeration.hasMoreElements()) {
                URLConnection connection = enumeration.nextElement().openConnection();
                if (connection instanceof JarURLConnection) {
                    JarFile jarFile = ((JarURLConnection)connection).getJarFile();
                    Object object = null;
                    try {
                        Enumeration<JarEntry> entryEnumeration = jarFile.entries();
                        while (entryEnumeration.hasMoreElements()) {
                            String name = entryEnumeration.nextElement().getName().trim();
                            if (!name.startsWith(PATH) || !name.endsWith(SUFFIX)) continue;
                            SchemaLoader.loadSchema(name.substring(PATH.length(), name.length() - SUFFIX.length()));
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (object != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        jarFile.close();
                        continue;
                    }
                }
                if (!(connection instanceof FileURLConnection)) continue;
                String[] content = SchemaLoader.readContentAndClose(connection.getInputStream()).split("\n");
                for (String string : content) {
                    String string2 = string.trim();
                    if (!string2.endsWith(SUFFIX)) continue;
                    SchemaLoader.loadSchema(string2.substring(0, string2.length() - SUFFIX.length()));
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.warn("load all breeze schema fail. error:" + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContentAndClose(InputStream inputStream) throws IOException {
        try {
            int len;
            ByteArrayOutputStream output = new ByteArrayOutputStream(512);
            byte[] buf = new byte[512];
            while ((len = inputStream.read(buf)) != -1) {
                output.write(buf, 0, len);
            }
            String string = output.toString("UTF-8");
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

