/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.net.core.Processor;
import com.qq.tars.rpc.protocol.Codec;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppService;
import com.qq.tars.server.core.ContextManager;
import java.lang.reflect.Method;

public class ServantHomeSkeleton
extends AppService {
    private String name = null;
    private Object servantImpl = null;
    private Class<?> apiClass = null;
    private Class<? extends Codec> codecClazz = null;
    private Class<? extends Processor> processorClazz = null;
    private AppContext appContext;

    public ServantHomeSkeleton(String name, Object servantImpl, Class<?> apiClass, Class<? extends Codec> codecClazz, Class<? extends Processor> processorClazz, int loadLimit) {
        this.name = name;
        this.servantImpl = servantImpl;
        this.apiClass = apiClass;
        this.codecClazz = codecClazz;
        this.processorClazz = processorClazz;
    }

    public Object getServant() {
        return this.servantImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Method method, Object ... args) throws Exception {
        Object value = null;
        try {
            this.preInvokeCapHomeSkeleton();
            value = method.invoke(this.servantImpl, this.fixParamValueType(method, args));
        }
        finally {
            if (!ContextManager.getContext().response().isAsyncMode()) {
                this.postInvokeCapHomeSkeleton();
            }
        }
        return value;
    }

    private Object[] fixParamValueType(Method method, Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return args;
        }
        if (args.length != parameterTypes.length) {
            return args;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            args[i] = this.fixValueDataType(parameterTypes[i], args[i]);
        }
        return args;
    }

    private Object fixValueDataType(Class<?> dataType, Object value) {
        Object dataValue = value;
        if (dataType != null && dataValue != null) {
            if ("short".equals(dataType.getName())) {
                dataValue = Short.valueOf(dataValue.toString());
            } else if ("byte".equals(dataType.getName())) {
                dataValue = Byte.valueOf(dataValue.toString());
            } else if (Character.TYPE == dataType) {
                dataValue = Character.valueOf(((String)value).charAt(0));
            } else if ("float".equals(dataType.getName())) {
                dataValue = Float.valueOf(dataValue.toString());
            }
        }
        return dataValue;
    }

    public void preInvokeCapHomeSkeleton() {
    }

    public void postInvokeCapHomeSkeleton() {
    }

    public Class<?> getApiClass() {
        return this.apiClass;
    }

    public Class<? extends Processor> getProcessorClass() {
        return this.processorClazz;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Class<? extends Codec> getCodecClass() {
        return this.codecClazz;
    }

    public void setAppContext(AppContext context) {
        this.appContext = context;
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }
}

