/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.base.AbstractMap;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerivedKeyHashMap<K, V>
extends AbstractMap<K, V> {
    private final KeyFunction<K, V> keyFunction;
    private CompactHashMap<K, V> compactHashMap = CompactHashMap.empty();

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, DerivedKeyHashMap<K, V>> factory(final KeyFunction<K, V> keyFunction) {
        return new BuilderFactory<Pair<K, V>, DerivedKeyHashMap<K, V>>(){

            @Override
            @NotNull
            public Builder<Pair<K, V>, DerivedKeyHashMap<K, V>> newBuilder() {
                return new AbstractSelfBuilder<Pair<K, V>, DerivedKeyHashMap<K, V>>(new DerivedKeyHashMap(keyFunction)){

                    @Override
                    @NotNull
                    public Builder<Pair<K, V>, DerivedKeyHashMap<K, V>> add(Pair<K, V> element) {
                        this.result = ((DerivedKeyHashMap)this.result).put(element.component1(), element.component2());
                        return this;
                    }
                };
            }
        };
    }

    public DerivedKeyHashMap(@NotNull KeyFunction<K, V> keyFunction) {
        this.keyFunction = keyFunction;
    }

    private DerivedKeyHashMap(KeyFunction<K, V> keyFunction, CompactHashMap<K, V> compactHashMap) {
        this.keyFunction = keyFunction;
        this.compactHashMap = compactHashMap;
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        return this.get(key) != null;
    }

    @Override
    @NotNull
    public DerivedKeyHashMap<K, V> put(@NotNull K key, V value) {
        return new DerivedKeyHashMap<K, V>(this.keyFunction, this.compactHashMap.put(key, value, this.keyFunction));
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        return this.compactHashMap.get(key, this.keyFunction);
    }

    @Override
    @NotNull
    public DerivedKeyHashMap<K, V> remove(@NotNull K key) {
        return new DerivedKeyHashMap<K, V>(this.keyFunction, this.compactHashMap.remove(key, this.keyFunction));
    }

    @Override
    public int size() {
        return this.compactHashMap.size();
    }

    @Override
    public <U> void forEach(final @NotNull Function<Pair<K, V>, U> f) {
        this.compactHashMap.forEach(new Function<Pair<K, V>, Object>(){

            @Override
            public Object invoke(Pair<K, V> parameter) {
                f.invoke(parameter);
                return null;
            }
        }, this.keyFunction);
    }

    @Override
    @NotNull
    public Iterator<Pair<K, V>> iterator() {
        return this.compactHashMap.iterator(this.keyFunction);
    }
}

