/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.linear.AnyMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math.linear.RealVector;

public interface RealMatrix
extends AnyMatrix {
    public RealMatrix createMatrix(int var1, int var2);

    public RealMatrix copy();

    public RealMatrix add(RealMatrix var1) throws IllegalArgumentException;

    public RealMatrix subtract(RealMatrix var1) throws IllegalArgumentException;

    public RealMatrix scalarAdd(double var1);

    public RealMatrix scalarMultiply(double var1);

    public RealMatrix multiply(RealMatrix var1) throws IllegalArgumentException;

    public RealMatrix preMultiply(RealMatrix var1) throws IllegalArgumentException;

    public double[][] getData();

    public double getNorm();

    public double getFrobeniusNorm();

    public RealMatrix getSubMatrix(int var1, int var2, int var3, int var4) throws MatrixIndexException;

    public RealMatrix getSubMatrix(int[] var1, int[] var2) throws MatrixIndexException;

    public void copySubMatrix(int var1, int var2, int var3, int var4, double[][] var5) throws MatrixIndexException, IllegalArgumentException;

    public void copySubMatrix(int[] var1, int[] var2, double[][] var3) throws MatrixIndexException, IllegalArgumentException;

    public void setSubMatrix(double[][] var1, int var2, int var3) throws MatrixIndexException;

    public RealMatrix getRowMatrix(int var1) throws MatrixIndexException;

    public void setRowMatrix(int var1, RealMatrix var2) throws MatrixIndexException, InvalidMatrixException;

    public RealMatrix getColumnMatrix(int var1) throws MatrixIndexException;

    public void setColumnMatrix(int var1, RealMatrix var2) throws MatrixIndexException, InvalidMatrixException;

    public RealVector getRowVector(int var1) throws MatrixIndexException;

    public void setRowVector(int var1, RealVector var2) throws MatrixIndexException, InvalidMatrixException;

    public RealVector getColumnVector(int var1) throws MatrixIndexException;

    public void setColumnVector(int var1, RealVector var2) throws MatrixIndexException, InvalidMatrixException;

    public double[] getRow(int var1) throws MatrixIndexException;

    public void setRow(int var1, double[] var2) throws MatrixIndexException, InvalidMatrixException;

    public double[] getColumn(int var1) throws MatrixIndexException;

    public void setColumn(int var1, double[] var2) throws MatrixIndexException, InvalidMatrixException;

    public double getEntry(int var1, int var2) throws MatrixIndexException;

    public void setEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public void addToEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public void multiplyEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public RealMatrix transpose();

    @Deprecated
    public RealMatrix inverse() throws InvalidMatrixException;

    @Deprecated
    public double getDeterminant();

    @Deprecated
    public boolean isSingular();

    public double getTrace() throws NonSquareMatrixException;

    public double[] operate(double[] var1) throws IllegalArgumentException;

    public RealVector operate(RealVector var1) throws IllegalArgumentException;

    public double[] preMultiply(double[] var1) throws IllegalArgumentException;

    public RealVector preMultiply(RealVector var1) throws IllegalArgumentException;

    public double walkInRowOrder(RealMatrixChangingVisitor var1) throws MatrixVisitorException;

    public double walkInRowOrder(RealMatrixPreservingVisitor var1) throws MatrixVisitorException;

    public double walkInRowOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    public double walkInRowOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    public double walkInColumnOrder(RealMatrixChangingVisitor var1) throws MatrixVisitorException;

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1) throws MatrixVisitorException;

    public double walkInColumnOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1) throws MatrixVisitorException;

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1) throws MatrixVisitorException;

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5) throws MatrixIndexException, MatrixVisitorException;

    @Deprecated
    public double[] solve(double[] var1) throws IllegalArgumentException, InvalidMatrixException;

    @Deprecated
    public RealMatrix solve(RealMatrix var1) throws IllegalArgumentException, InvalidMatrixException;
}

