/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

@FunctionalInterface
public interface CheckedCallable<T, E extends Throwable> {
    public T call() throws E;

    default public Runnable unchecked() {
        return () -> {
            try {
                this.call();
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)t;
                    throw runtimeException;
                }
                if (t instanceof Error) {
                    Error error = (Error)t;
                    throw error;
                }
                throw new IllegalStateException(t);
            }
        };
    }
}

