/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.mapper.NamespacePluginRelMapper;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.NamespacePluginDTO;
import org.apache.shenyu.admin.model.entity.NamespacePluginRelDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.NamespacePluginQuery;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.model.vo.PluginSnapshotVO;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.service.publish.NamespacePluginEventPublisher;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespacePluginServiceImpl
implements NamespacePluginService {
    private final NamespacePluginRelMapper namespacePluginRelMapper;
    private final NamespacePluginEventPublisher namespacePluginEventPublisher;
    private final PluginMapper pluginMapper;
    private final SelectorMapper selectorMapper;
    private final PluginHandleMapper pluginHandleMapper;

    public NamespacePluginServiceImpl(NamespacePluginRelMapper namespacePluginRelMapper, NamespacePluginEventPublisher namespacePluginEventPublisher, PluginMapper pluginMapper, SelectorMapper selectorMapper, PluginHandleMapper pluginHandleMapper) {
        this.namespacePluginRelMapper = namespacePluginRelMapper;
        this.namespacePluginEventPublisher = namespacePluginEventPublisher;
        this.pluginMapper = pluginMapper;
        this.selectorMapper = selectorMapper;
        this.pluginHandleMapper = pluginHandleMapper;
    }

    @Override
    public NamespacePluginVO findById(String id) {
        return this.namespacePluginRelMapper.selectById(id);
    }

    @Override
    public NamespacePluginVO findByNamespaceIdAndPluginId(String namespaceId, String pluginId) {
        return this.namespacePluginRelMapper.selectByPluginIdAndNamespaceId(pluginId, namespaceId);
    }

    @Override
    public NamespacePluginVO create(String namespaceId, String pluginId) {
        NamespacePluginVO existNamespacePluginVO = this.namespacePluginRelMapper.selectByPluginIdAndNamespaceId(pluginId, namespaceId);
        if (Objects.nonNull(existNamespacePluginVO)) {
            throw new ShenyuAdminException("The plugin of namespace is exist\uff01");
        }
        PluginDO pluginDO = this.pluginMapper.selectById(pluginId);
        NamespacePluginRelDO namespacePluginRelDO = NamespacePluginRelDO.buildNamespacePluginRelDO(pluginDO, namespaceId);
        this.namespacePluginRelMapper.insertSelective(namespacePluginRelDO);
        return this.namespacePluginRelMapper.selectByPluginIdAndNamespaceId(pluginId, namespaceId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String update(NamespacePluginDTO namespacePluginDTO) {
        NamespacePluginVO before = this.namespacePluginRelMapper.selectById(namespacePluginDTO.getId());
        NamespacePluginRelDO namespacePluginRelDO = NamespacePluginRelDO.buildNamespacePluginRelDO(namespacePluginDTO);
        if (this.namespacePluginRelMapper.updateSelective(namespacePluginRelDO) > 0) {
            NamespacePluginVO now = this.namespacePluginRelMapper.selectById(namespacePluginDTO.getId());
            this.namespacePluginEventPublisher.onUpdated(now, before);
        }
        return "update success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        List<NamespacePluginVO> namespacePluginVOS = this.namespacePluginRelMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(namespacePluginVOS)) {
            return "The plugin(s) does not exist\uff01";
        }
        if (this.namespacePluginRelMapper.deleteByIds(ListUtil.map(namespacePluginVOS, PluginVO::getId)) > 0) {
            this.namespacePluginEventPublisher.onDeleted((Collection<NamespacePluginVO>)namespacePluginVOS);
        }
        return "";
    }

    @Override
    public CommonPager<NamespacePluginVO> listByPage(NamespacePluginQuery namespacePluginQuery) {
        return PageResultUtils.result(namespacePluginQuery.getPageParameter(), () -> this.namespacePluginRelMapper.selectByQuery(namespacePluginQuery));
    }

    @Override
    public List<PluginData> listAll(String namespaceId) {
        return ListUtil.map(this.namespacePluginRelMapper.selectAllByNamespaceId(namespaceId), PluginTransfer.INSTANCE::mapToData);
    }

    @Override
    public List<PluginData> listAll() {
        return ListUtil.map(this.namespacePluginRelMapper.selectAll(), PluginTransfer.INSTANCE::mapToData);
    }

    @Override
    public List<NamespacePluginVO> listByNamespaceId(String namespaceId) {
        return this.namespacePluginRelMapper.selectAllByNamespaceId(namespaceId);
    }

    @Override
    public List<NamespacePluginVO> listAllData(String namespaceId) {
        List<NamespacePluginVO> namespacePluginVOList = this.namespacePluginRelMapper.selectByNamespaceId(namespaceId);
        if (CollectionUtils.isEmpty(namespacePluginVOList)) {
            return Lists.newArrayList();
        }
        return namespacePluginVOList;
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        List<NamespacePluginVO> namespacePluginVOList = this.namespacePluginRelMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(namespacePluginVOList)) {
            return "The plugin(s) does not exist\uff01";
        }
        namespacePluginVOList.forEach(pluginNsRelDO -> pluginNsRelDO.setEnabled(enabled));
        this.namespacePluginRelMapper.updateEnableByIdList(ids, enabled);
        if (CollectionUtils.isNotEmpty(namespacePluginVOList)) {
            this.namespacePluginEventPublisher.onEnabled(namespacePluginVOList);
        }
        return "";
    }

    @Override
    public String enabled(String namespaceId, List<String> pluginIds, Boolean enabled) {
        List<NamespacePluginVO> namespacePluginList = this.namespacePluginRelMapper.selectByNamespaceId(namespaceId);
        if (CollectionUtils.isEmpty(namespacePluginList)) {
            return "";
        }
        Map namespacePluginMap = namespacePluginList.stream().collect(Collectors.toMap(NamespacePluginVO::getPluginId, Function.identity()));
        ArrayList updateList = Lists.newArrayList();
        for (String pluginId : pluginIds) {
            NamespacePluginVO namespacePluginVO = (NamespacePluginVO)namespacePluginMap.get(pluginId);
            if (Objects.isNull(namespacePluginVO)) {
                return "The plugin(s) does not exist\uff01";
            }
            namespacePluginVO.setEnabled(enabled);
            updateList.add(namespacePluginVO);
        }
        this.namespacePluginRelMapper.updateEnableByNamespaceIdAndPluginIdList(namespaceId, pluginIds, enabled);
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.namespacePluginEventPublisher.onEnabled(updateList);
        }
        return "";
    }

    @Override
    public List<PluginSnapshotVO> activePluginSnapshot(String namespaceId) {
        List<NamespacePluginVO> namespacePluginVOList = this.namespacePluginRelMapper.selectByNamespaceId(namespaceId);
        if (CollectionUtils.isEmpty(namespacePluginVOList)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(namespacePluginVOList = namespacePluginVOList.stream().filter(PluginVO::getEnabled).toList())) {
            return Lists.newArrayList();
        }
        List<String> pluginIds = namespacePluginVOList.stream().map(NamespacePluginVO::getPluginId).toList();
        List<SelectorDO> selectorDOList = this.selectorMapper.selectAllByNamespaceId(namespaceId);
        Map<String, Integer> selectorCountMap = selectorDOList.stream().collect(Collectors.groupingBy(SelectorDO::getPluginId, Collectors.summingInt(x -> 1)));
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByPluginIdList(pluginIds);
        Map<String, Integer> pluginHandleCountMap = pluginHandleDOList.stream().collect(Collectors.groupingBy(PluginHandleDO::getPluginId, Collectors.summingInt(x -> 1)));
        return namespacePluginVOList.stream().map(namespacePluginVO -> {
            PluginSnapshotVO pluginSnapshotVO = new PluginSnapshotVO();
            pluginSnapshotVO.setId(namespacePluginVO.getPluginId());
            pluginSnapshotVO.setName(namespacePluginVO.getName());
            pluginSnapshotVO.setConfig(namespacePluginVO.getConfig());
            pluginSnapshotVO.setRole(namespacePluginVO.getRole());
            pluginSnapshotVO.setSelectorCount(selectorCountMap.getOrDefault(namespacePluginVO.getPluginId(), 0));
            pluginSnapshotVO.setHandleCount(pluginHandleCountMap.getOrDefault(namespacePluginVO.getPluginId(), 0));
            return pluginSnapshotVO;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(String namespace, List<NamespacePluginDTO> namespacePluginList, ConfigsImportContext context) {
        if (CollectionUtils.isEmpty(namespacePluginList)) {
            return ConfigImportResult.success();
        }
        Map<String, NamespacePluginRelDO> existPluginMap = this.namespacePluginRelMapper.listByNamespaceId(namespace).stream().filter(Objects::nonNull).collect(Collectors.toMap(NamespacePluginRelDO::getPluginId, x -> x));
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        for (NamespacePluginDTO namespacePluginDTO : namespacePluginList) {
            String pluginId = context.getPluginTemplateIdMapping().get(namespacePluginDTO.getPluginId());
            if (existPluginMap.containsKey(pluginId)) {
                errorMsgBuilder.append(pluginId).append(",");
                continue;
            }
            namespacePluginDTO.setId(UUIDUtils.getInstance().generateShortUuid());
            namespacePluginDTO.setNamespaceId(namespace);
            namespacePluginDTO.setPluginId(pluginId);
            NamespacePluginRelDO namespacePluginRelDO = NamespacePluginRelDO.buildNamespacePluginRelDO(namespacePluginDTO);
            if (this.namespacePluginRelMapper.insertSelective(namespacePluginRelDO) <= 0) continue;
            ++successCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail plugin: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    public List<PluginData> listByNamespace(String namespace) {
        List<NamespacePluginVO> namespacePluginList = this.namespacePluginRelMapper.selectAllByNamespaceId(namespace);
        if (CollectionUtils.isEmpty(namespacePluginList)) {
            return Lists.newArrayList();
        }
        List<String> pluginIds = namespacePluginList.stream().map(NamespacePluginVO::getPluginId).distinct().collect(Collectors.toList());
        return ListUtil.map(this.pluginMapper.selectByIds(pluginIds), PluginTransfer.INSTANCE::mapToData);
    }
}

