/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite.trigger;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.StatusChangeHandler;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.CounterOptions;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class TriggerCounter {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerCounter.class);
    protected final String ruleName;
    protected final CircuitBreakerProto.TriggerCondition triggerCondition;
    protected final Resource resource;
    protected final StatusChangeHandler statusChangeHandler;
    protected final AtomicBoolean suspended = new AtomicBoolean(false);

    public TriggerCounter(String ruleName, CounterOptions counterOptions) {
        this.triggerCondition = counterOptions.getTriggerCondition();
        this.ruleName = ruleName;
        this.resource = counterOptions.getResource();
        this.statusChangeHandler = counterOptions.getStatusChangeHandler();
        this.init();
    }

    public void suspend() {
        this.suspended.set(true);
        LOG.info("[CircuitBreaker][Counter] counter {} suspend", (Object)this.ruleName);
    }

    public void resume() {
        this.suspended.set(false);
        LOG.info("[CircuitBreaker][Counter] counter {} resume", (Object)this.ruleName);
    }

    protected abstract void init();

    public abstract void report(boolean var1);
}

