/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.client.api.SDKContext;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public interface ServiceCallResultListener {
    public static final String CONTEXT_KEY_RESULT_LISTENERS = "serviceCallResultListeners";

    public void init(SDKContext var1);

    public void onServiceCallResult(InstanceGauge var1);

    public void destroy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServiceCallResultListener> getServiceCallResultListeners(SDKContext sdkContext) {
        Class<ServiceCallResultListener> clazz = ServiceCallResultListener.class;
        synchronized (ServiceCallResultListener.class) {
            ArrayList<ServiceCallResultListener> serviceCallResultListeners = (ArrayList<ServiceCallResultListener>)sdkContext.getValueContext().getValue(CONTEXT_KEY_RESULT_LISTENERS);
            if (null != serviceCallResultListeners) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return serviceCallResultListeners;
            }
            serviceCallResultListeners = new ArrayList<ServiceCallResultListener>();
            ServiceLoader<ServiceCallResultListener> listeners = ServiceLoader.load(ServiceCallResultListener.class);
            for (ServiceCallResultListener listener : listeners) {
                listener.init(sdkContext);
                serviceCallResultListeners.add(listener);
            }
            final ArrayList<ServiceCallResultListener> outListeners = serviceCallResultListeners;
            sdkContext.registerDestroyHook(new Destroyable(){

                @Override
                protected void doDestroy() {
                    for (ServiceCallResultListener listener : outListeners) {
                        listener.destroy();
                    }
                }
            });
            sdkContext.getValueContext().setValue(CONTEXT_KEY_RESULT_LISTENERS, outListeners);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serviceCallResultListeners;
        }
    }
}

