/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.FunctionalDecorator;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.FunctionalDecoratorRequest;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import com.tencent.polaris.circuitbreak.client.api.DefaultInvokeHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultFunctionalDecorator
implements FunctionalDecorator {
    private final InvokeHandler invokeHandler;

    public DefaultFunctionalDecorator(FunctionalDecoratorRequest makeDecoratorRequest, CircuitBreakAPI circuitBreakAPI) {
        this.invokeHandler = new DefaultInvokeHandler(makeDecoratorRequest, circuitBreakAPI);
    }

    @Override
    public <T> Supplier<T> decorateSupplier(final Supplier<T> supplier) {
        return new Supplier<T>(){

            @Override
            public T get() {
                DefaultFunctionalDecorator.this.invokeHandler.acquirePermission();
                long startTimeMilli = System.currentTimeMillis();
                try {
                    Object result = supplier.get();
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setResult(result);
                    DefaultFunctionalDecorator.this.invokeHandler.onSuccess(responseContext);
                    return result;
                }
                catch (Throwable e) {
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setError(e);
                    DefaultFunctionalDecorator.this.invokeHandler.onError(responseContext);
                    throw e;
                }
            }
        };
    }

    @Override
    public <T> Consumer<T> decorateConsumer(final Consumer<T> consumer) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                DefaultFunctionalDecorator.this.invokeHandler.acquirePermission();
                long startTimeMilli = System.currentTimeMillis();
                try {
                    consumer.accept(t);
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    DefaultFunctionalDecorator.this.invokeHandler.onSuccess(responseContext);
                }
                catch (Throwable e) {
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setError(e);
                    DefaultFunctionalDecorator.this.invokeHandler.onError(responseContext);
                    throw e;
                }
            }
        };
    }

    @Override
    public <T, R> Function<T, R> decorateFunction(final Function<T, R> function) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                DefaultFunctionalDecorator.this.invokeHandler.acquirePermission();
                long startTimeMilli = System.currentTimeMillis();
                try {
                    Object result = function.apply(t);
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setResult(result);
                    DefaultFunctionalDecorator.this.invokeHandler.onSuccess(responseContext);
                    return result;
                }
                catch (Throwable e) {
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setError(e);
                    DefaultFunctionalDecorator.this.invokeHandler.onError(responseContext);
                    throw e;
                }
            }
        };
    }

    @Override
    public <T> Predicate<T> decoratePredicate(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                DefaultFunctionalDecorator.this.invokeHandler.acquirePermission();
                long startTimeMilli = System.currentTimeMillis();
                try {
                    boolean result = predicate.test(t);
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setResult(result);
                    DefaultFunctionalDecorator.this.invokeHandler.onSuccess(responseContext);
                    return result;
                }
                catch (Throwable e) {
                    long delay = System.currentTimeMillis() - startTimeMilli;
                    InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                    responseContext.setDuration(delay);
                    responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                    responseContext.setError(e);
                    DefaultFunctionalDecorator.this.invokeHandler.onError(responseContext);
                    throw e;
                }
            }
        };
    }
}

