/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.servo.ServoRegistry;
import java.time.Duration;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;

public class DefaultRegistryInitializer
implements MetricsInitializer {
    public static final String SERVO_POLLERS = "servo.pollers";
    private GlobalRegistry globalRegistry;
    private ServoRegistry registry;

    public int getOrder() {
        return -10;
    }

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.globalRegistry = globalRegistry;
        System.setProperty("spectator.api.gaugePollingFrequency", Duration.ofMillis(config.getMsPollInterval()).toString());
        System.setProperty(SERVO_POLLERS, String.valueOf(config.getMsPollInterval()));
        this.registry = new ServoRegistry();
        globalRegistry.add((Registry)this.registry);
    }

    public void destroy() {
        if (this.registry != null) {
            DefaultMonitorRegistry.getInstance().unregister((Monitor)this.registry);
            this.globalRegistry.remove((Registry)this.registry);
        }
    }
}

