/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class HiveDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String METASTORE_URI = "metastore_uri";
    private static final String KERBEROS_PRINCIPAL = "kerberos_principal";
    private static final String KERBEROS_KEYTAB_PATH = "kerberos_keytab_path";
    private static final String KERBEROS_KRB5_CONF_PATH = "kerberos_krb5_conf_path";
    private static final String HDFS_SITE_PATH = "hdfs_site_path";
    private static final String HIVE_SITE_PATH = "hive_site_path";
    private static final String HIVE_HADOOP_CONF = "hive.hadoop.conf";
    private static final String HIVE_HADOOP_CONF_PATH = "hive.hadoop.conf-path";
    private static final String TABLE_NAME = "table_name";
    private static final List<String> excludes = Arrays.asList("metastore_uri", "kerberos_principal", "kerberos_keytab_path", "kerberos_krb5_conf_path", "hdfs_site_path", "hive_site_path", "table_name", "hive.hadoop.conf", "hive.hadoop.conf-path");

    @Override
    public String getDataSourceName() {
        return "HIVE";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludes);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (dataSourceOption.getDatabases().size() == 1 && dataSourceOption.getTables().size() == 1) {
            connectorConfig = connectorConfig.withValue(TABLE_NAME, ConfigValueFactory.fromAnyRef((Object)(dataSourceOption.getDatabases().get(0) + "." + dataSourceOption.getTables().get(0))));
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

