/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.security;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils
implements InitializingBean {
    @Value(value="${jwt.expireTime}")
    private int expireTime;
    @Value(value="${jwt.secretKey}")
    private String secretKey;
    @Value(value="${jwt.algorithm}")
    private String algorithmString;
    private SignatureAlgorithm algorithm = null;

    public void afterPropertiesSet() throws Exception {
        this.algorithm = SignatureAlgorithm.valueOf((String)this.algorithmString);
    }

    public String genToken(Map<String, Object> data) {
        Date currentDate = new Date();
        Date expireDate = DateUtils.addSeconds((Date)currentDate, (int)this.expireTime);
        return Jwts.builder().signWith(this.algorithm, this.secretKey.getBytes(StandardCharsets.UTF_8)).setId(UUID.randomUUID().toString()).setClaims(data).setIssuedAt(currentDate).setExpiration(expireDate).compact();
    }

    public Map<String, Object> parseToken(String token) {
        Jws claims = Jwts.parser().setSigningKey(this.secretKey.getBytes(StandardCharsets.UTF_8)).parseClaimsJws(token);
        return (Map)claims.getBody();
    }
}

