/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.dal.dao.IDatasourceDao;
import org.apache.seatunnel.app.dal.entity.Datasource;
import org.apache.seatunnel.app.dal.mapper.DatasourceMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DatasourceDaoImpl
implements IDatasourceDao {
    @Resource
    private DatasourceMapper datasourceMapper;

    @Override
    public boolean insertDatasource(Datasource datasource) {
        return this.datasourceMapper.insert(datasource) > 0;
    }

    @Override
    public Datasource selectDatasourceById(Long id) {
        return (Datasource)this.datasourceMapper.selectById(id);
    }

    @Override
    public boolean deleteDatasourceById(Long id) {
        return this.datasourceMapper.deleteById(id) > 0;
    }

    @Override
    public Datasource queryDatasourceByName(String name) {
        return (Datasource)this.datasourceMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"datasource_name", (Object)name));
    }

    @Override
    public boolean updateDatasourceById(Datasource datasource) {
        return this.datasourceMapper.updateById(datasource) > 0;
    }

    @Override
    public boolean checkDatasourceNameUnique(String dataSourceName, Long dataSourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"datasource_name", (Object)dataSourceName);
        queryWrapper.ne((Object)"id", (Object)dataSourceId);
        return this.datasourceMapper.selectList((Wrapper)queryWrapper).size() <= 0;
    }

    @Override
    public IPage<Datasource> selectDatasourcePage(Page<Datasource> page) {
        return this.datasourceMapper.selectPage((IPage)page, (Wrapper)new QueryWrapper());
    }

    @Override
    public IPage<Datasource> selectDatasourceByParam(Page<Datasource> page, List<Long> availableDatasourceIds, String searchVal, String pluginName) {
        QueryWrapper datasourceQueryWrapper = new QueryWrapper();
        datasourceQueryWrapper.in((Object)"id", availableDatasourceIds);
        if (searchVal != null && !searchVal.isEmpty() && pluginName != null && !pluginName.isEmpty()) {
            return this.datasourceMapper.selectPage((IPage)page, (Wrapper)((QueryWrapper)datasourceQueryWrapper.eq((Object)"plugin_name", (Object)pluginName)).like((Object)"datasource_name", (Object)searchVal));
        }
        if (searchVal != null && !searchVal.isEmpty()) {
            return this.datasourceMapper.selectPage((IPage)page, (Wrapper)datasourceQueryWrapper.like((Object)"datasource_name", (Object)searchVal));
        }
        if (pluginName != null && !pluginName.isEmpty()) {
            return this.datasourceMapper.selectPage((IPage)page, (Wrapper)datasourceQueryWrapper.eq((Object)"plugin_name", (Object)pluginName));
        }
        return this.datasourceMapper.selectPage((IPage)page, (Wrapper)datasourceQueryWrapper);
    }

    @Override
    public String queryDatasourceNameById(Long id) {
        return ((Datasource)this.datasourceMapper.selectById(id)).getDatasourceName();
    }

    @Override
    public List<Datasource> selectDatasourceByPluginName(String pluginName, String pluginVersion) {
        return this.datasourceMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"plugin_name", (Object)pluginName)).eq((Object)"plugin_version", (Object)pluginVersion));
    }

    @Override
    public List<Datasource> selectDatasourceByIds(List<Long> ids) {
        return this.datasourceMapper.selectBatchIds(ids);
    }

    @Override
    public List<Datasource> queryAll() {
        return this.datasourceMapper.selectList((Wrapper)new QueryWrapper());
    }

    @Override
    public List<Datasource> selectByIds(List<Long> ids) {
        return this.datasourceMapper.selectBatchIds(ids);
    }

    @Override
    public List<Datasource> selectDatasourceByUserId(int userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"create_user_id", (Object)userId);
        return this.datasourceMapper.selectList((Wrapper)queryWrapper);
    }
}

