/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.connector.ConnectorStatus;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.service.IConnectorService;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/connector"})
@RestController
public class ConnectorController {
    @Resource
    private IConnectorService connectorService;

    @GetMapping(value={"/sources"})
    @ApiOperation(value="list all source connector", httpMethod="GET")
    public Result<List<ConnectorInfo>> listSource(@RequestParam(defaultValue="ALL") ConnectorStatus status) {
        return Result.success(this.connectorService.listSources(status));
    }

    @GetMapping(value={"/transforms"})
    @ApiOperation(value="list all transforms", httpMethod="GET")
    public Result<List<ConnectorInfo>> listAllTransform() {
        return Result.success(this.connectorService.listTransforms());
    }

    @GetMapping(value={"/sinks"})
    @ApiOperation(value="list all sink connector", httpMethod="GET")
    public Result<List<ConnectorInfo>> listSink(@RequestParam(defaultValue="ALL") ConnectorStatus status) {
        return Result.success(this.connectorService.listSinks(status));
    }

    @GetMapping(value={"/sync"})
    @ApiOperation(value="sync all connector from disk", httpMethod="GET")
    public Result<List<ConnectorInfo>> sync() throws IOException {
        this.connectorService.sync();
        return Result.success();
    }

    @GetMapping(value={"/form"})
    @ApiOperation(value="get source connector form structure", httpMethod="GET")
    public Result<String> getConnectorFormStructure(@ApiParam(value="connector type", required=true) @RequestParam String connectorType, @ApiParam(value="connector name", required=true) @RequestParam String connectorName) {
        return Result.success(JsonUtils.toJsonString((Object)this.connectorService.getConnectorFormStructure(connectorType, connectorName)));
    }
}

