/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;

public final class CacheEventDataCodec {
    private static final int CACHE_EVENT_TYPE_FIELD_OFFSET = 0;
    private static final int OLD_VALUE_AVAILABLE_FIELD_OFFSET = 4;
    private static final int INITIAL_FRAME_SIZE = 5;

    private CacheEventDataCodec() {
    }

    public static void encode(ClientMessage clientMessage, CacheEventData cacheEventData) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[5]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, cacheEventData.getCacheEventType());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 4, cacheEventData.isOldValueAvailable());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, cacheEventData.getName());
        CodecUtil.encodeNullable(clientMessage, cacheEventData.getDataKey(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheEventData.getDataValue(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheEventData.getDataOldValue(), DataCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CacheEventDataImpl decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int cacheEventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        boolean oldValueAvailable = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 4);
        String name = StringCodec.decode(iterator);
        Data dataKey = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data dataValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data dataOldValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createCacheEventData(name, cacheEventType, dataKey, dataValue, dataOldValue, oldValueAvailable);
    }
}

