/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.admin.client.RangerPolicySource;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedResourcePolicySource
extends RangerPolicySource {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedResourcePolicySource.class);
    private String prefix;
    private String prefixWithAppId;
    private ServicePolicies policies;
    private RangerRoles roles;
    private ServiceTags tags;
    private RangerUserStore userStore;

    @Override
    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        super.init(serviceName, appId, configPropertyPrefix, config);
        String directory = config.get(configPropertyPrefix + ".policy.source.embedded_resource.path");
        if (StringUtils.isBlank((CharSequence)directory)) {
            directory = "/";
        } else if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        this.prefix = directory + serviceName;
        this.prefixWithAppId = StringUtils.isBlank((CharSequence)appId) ? null : directory + appId + "_" + serviceName;
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadPolicies();
        return lastKnownVersion == -1L || this.policies == null || this.policies.getPolicyVersion() == null || !this.policies.getPolicyVersion().equals(lastKnownVersion) ? this.policies : null;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownVersion, long lastActivationTimeInMills) throws Exception {
        this.loadRoles();
        return lastKnownVersion == -1L || this.roles == null || this.roles.getRoleVersion() == null || !this.roles.getRoleVersion().equals(lastKnownVersion) ? this.roles : null;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadTags();
        return lastKnownVersion == -1L || this.tags == null || this.tags.getTagVersion() == null || !this.tags.getTagVersion().equals(lastKnownVersion) ? this.tags : null;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadUserStore();
        return lastKnownVersion == -1L || this.userStore == null || this.userStore.getUserStoreVersion() == null || !this.userStore.getUserStoreVersion().equals(lastKnownVersion) ? this.userStore : null;
    }

    private void loadPolicies() throws Exception {
        if (this.policies == null) {
            InputStream input = this.getResourceStream(".json");
            this.policies = (ServicePolicies)this.gson.fromJson((Reader)new InputStreamReader(input), ServicePolicies.class);
        }
    }

    private void loadRoles() throws Exception {
        if (this.roles == null) {
            InputStream input = this.getResourceStream("_roles.json");
            this.roles = (RangerRoles)this.gson.fromJson((Reader)new InputStreamReader(input), RangerRoles.class);
        }
    }

    private void loadUserStore() throws Exception {
        if (this.userStore == null) {
            InputStream input = this.getResourceStream("_userstore.json");
            this.userStore = (RangerUserStore)this.gson.fromJson((Reader)new InputStreamReader(input), RangerUserStore.class);
        }
    }

    private void loadTags() throws Exception {
        if (this.tags == null) {
            InputStream input = this.getResourceStream("_tag.json");
            this.tags = (ServiceTags)this.gson.fromJson((Reader)new InputStreamReader(input), ServiceTags.class);
        }
    }

    private InputStream getResourceStream(String suffix) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.prefix)) {
            throw new Exception(EmbeddedResourcePolicySource.class.getName() + ": not initialized");
        }
        try {
            InputStream src = this.getClass().getResourceAsStream(this.prefix + suffix);
            if (src == null && StringUtils.isNotBlank((CharSequence)this.prefixWithAppId)) {
                src = this.getClass().getResourceAsStream(this.prefixWithAppId + suffix);
            }
            if (src == null) {
                LOG.error("{}{}: resource not found", (Object)this.prefix, (Object)suffix);
                throw new Exception(this.prefix + suffix + ": resource not found");
            }
            return src;
        }
        catch (Exception excp) {
            LOG.error("{}{}: resource not found", new Object[]{this.prefix, suffix, excp});
            throw new Exception(this.prefix + suffix + ": resource not found", excp);
        }
    }
}

