/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.apache.ranger.plugin.model.RangerInlinePolicy;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPrincipal;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestWrapper;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerInlinePolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerInlinePolicyEvaluator.class);
    private static final String PRINCIPAL_G_PUBLIC = "g:public";
    private final RangerInlinePolicy policy;
    private final RangerPolicyEngine policyEngine;
    private final List<GrantEvaluator> grants;

    public RangerInlinePolicyEvaluator(RangerInlinePolicy policy, RangerPolicyEngine policyEngine) {
        this.policy = policy;
        this.policyEngine = policyEngine;
        this.grants = this.toGrantEvaluators(policy);
        LOG.debug("RangerInlinePolicyEvaluator(policy={})", (Object)policy);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public void evaluate(RangerAccessRequest request, RangerAccessResult result) {
        LOG.debug("==> RangerInlinePolicyEvaluator.evaluate({}, {}, {})", new Object[]{this.policy, request, result});
        if (request != null && result != null) {
            boolean evalInlinePolicy;
            boolean isAllowed;
            boolean bl = isAllowed = result.getIsAccessDetermined() && result.getIsAllowed();
            if (this.policy.getMode() == null || this.policy.getMode() == RangerInlinePolicy.Mode.INLINE) {
                evalInlinePolicy = true;
            } else if (this.policy.getMode() == RangerInlinePolicy.Mode.RANGER_AND_INLINE) {
                evalInlinePolicy = isAllowed;
            } else {
                boolean bl2 = evalInlinePolicy = !isAllowed;
            }
            if (evalInlinePolicy) {
                isAllowed = this.isAllowed(request);
                result.setIsAllowed(isAllowed);
                result.setIsAccessDetermined(true);
                result.setPolicyId(-1L);
                result.setPolicyVersion(null);
                result.setReason("inline-policy");
            }
        }
        LOG.debug("<== RangerInlinePolicyEvaluator.evaluate({}, {}, {})", new Object[]{this.policy, request, result});
    }

    private boolean isAllowed(RangerAccessRequest request) {
        boolean ret;
        block1: {
            GrantEvaluator evaluator;
            ret = this.isAllowedForGrantor(request);
            if (!ret || this.grants.isEmpty()) break block1;
            Iterator<GrantEvaluator> iterator = this.grants.iterator();
            while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAllowed(request))) {
            }
        }
        return ret;
    }

    private boolean isAllowedForGrantor(RangerAccessRequest request) {
        boolean ret;
        RangerPrincipal grantor = RangerPrincipal.toPrincipal(this.policy.getGrantor());
        if (grantor != null) {
            try (RangerGrantorAccessRequest grantorAccessReq = new RangerGrantorAccessRequest(request, grantor);){
                RangerAccessResult result = this.policyEngine.evaluatePolicies(grantorAccessReq, 0, null);
                ret = result != null && result.getIsAccessDetermined() && result.getIsAllowed();
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private StringBuilder toString(StringBuilder sb) {
        sb.append("RangerInlinePolicyEvaluator={");
        sb.append("policy={").append(this.policy).append("}");
        sb.append("}");
        return sb;
    }

    private List<GrantEvaluator> toGrantEvaluators(RangerInlinePolicy policy) {
        if (CollectionUtils.isEmpty(policy.getGrants())) {
            return Collections.emptyList();
        }
        ArrayList<GrantEvaluator> ret = new ArrayList<GrantEvaluator>(policy.getGrants().size());
        for (RangerInlinePolicy.Grant grant : policy.getGrants()) {
            GrantEvaluator evaluator = new GrantEvaluator(grant);
            ret.add(evaluator);
        }
        return ret;
    }

    private static class RangerGrantorAccessRequest
    extends RangerAccessRequestWrapper
    implements AutoCloseable {
        private final String user;
        private final Set<String> userGroups;
        private final Set<String> userRoles;
        private final String savedUser;
        private final Set<String> savedUserRoles;

        public RangerGrantorAccessRequest(RangerAccessRequest request, RangerPrincipal grantor) {
            super(request, request.getAccessType());
            this.user = grantor.getType() == RangerPrincipal.PrincipalType.USER ? grantor.getName() : "";
            this.userGroups = grantor.getType() == RangerPrincipal.PrincipalType.GROUP ? Collections.singleton(grantor.getName()) : Collections.emptySet();
            this.userRoles = grantor.getType() == RangerPrincipal.PrincipalType.ROLE ? Collections.singleton(grantor.getName()) : Collections.emptySet();
            this.savedUser = RangerAccessRequestUtil.getCurrentUserFromContext(request.getContext());
            this.savedUserRoles = RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext());
            RangerAccessRequestUtil.setCurrentUserInContext(this.getContext(), this.user);
            RangerAccessRequestUtil.setCurrentUserRolesInContext(this.getContext(), this.userRoles);
        }

        @Override
        public void close() {
            RangerAccessRequestUtil.setCurrentUserInContext(this.getContext(), this.savedUser);
            RangerAccessRequestUtil.setCurrentUserRolesInContext(this.getContext(), this.savedUserRoles);
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public Set<String> getUserGroups() {
            return this.userGroups;
        }

        @Override
        public Set<String> getUserRoles() {
            return this.userRoles;
        }

        @Override
        public RangerInlinePolicy getInlinePolicy() {
            return null;
        }
    }

    private class GrantEvaluator {
        private final RangerInlinePolicy.Grant grant;
        private final Set<String> permissions;
        private final Set<RangerPolicyResourceMatcher> resourceMatchers = new HashSet<RangerPolicyResourceMatcher>();

        public GrantEvaluator(RangerInlinePolicy.Grant grant) {
            this.grant = grant;
            this.permissions = RangerInlinePolicyEvaluator.this.policyEngine.getServiceDefHelper().expandImpliedAccessGrants(grant.getPermissions());
            if (grant.getResources() != null) {
                for (String resource : grant.getResources()) {
                    try {
                        Map<String, RangerPolicy.RangerPolicyResource> policyResources = RangerInlinePolicyEvaluator.this.policyEngine.getServiceDefHelper().parseResourceToPolicyResources(resource);
                        RangerDefaultPolicyResourceMatcher resourceMatcher = new RangerDefaultPolicyResourceMatcher();
                        resourceMatcher.setServiceDef(RangerInlinePolicyEvaluator.this.policyEngine.getServiceDef());
                        resourceMatcher.setPolicyResources(policyResources, 0);
                        resourceMatcher.setPluginContext(RangerInlinePolicyEvaluator.this.policyEngine.getPluginContext());
                        resourceMatcher.setServiceDefHelper(RangerInlinePolicyEvaluator.this.policyEngine.getServiceDefHelper());
                        resourceMatcher.init();
                        this.resourceMatchers.add(resourceMatcher);
                    }
                    catch (RangerAuthzException excp) {
                        LOG.debug("GrantEvaluator(): invalid resource {}", (Object)resource);
                    }
                }
            }
            LOG.debug("RangerGrantEvaluator(grant={})", (Object)grant);
        }

        public boolean isAllowed(RangerAccessRequest request) {
            boolean ret = this.isPrincipalMatch(request) && this.isPermissionMatch(request) && this.isResourceMatch(request);
            LOG.debug("isAllowed(grant={}, request={}): ret={}", new Object[]{this.grant, request, ret});
            return ret;
        }

        private boolean isPrincipalMatch(RangerAccessRequest request) {
            boolean ret;
            boolean bl = ret = CollectionUtils.isEmpty(this.grant.getPrincipals()) || this.grant.getPrincipals().contains(RangerInlinePolicyEvaluator.PRINCIPAL_G_PUBLIC);
            if (!ret) {
                if (StringUtils.isNotBlank((CharSequence)request.getUser())) {
                    ret = this.grant.getPrincipals().contains("u:" + request.getUser());
                }
                if (!ret && CollectionUtils.isNotEmpty(request.getUserGroups())) {
                    for (String groupName : request.getUserGroups()) {
                        ret = this.grant.getPrincipals().contains("g:" + groupName);
                        if (!ret) continue;
                        break;
                    }
                }
                if (!ret && CollectionUtils.isNotEmpty(request.getUserRoles())) {
                    for (String roleName : request.getUserRoles()) {
                        ret = this.grant.getPrincipals().contains("r:" + roleName);
                        if (!ret) continue;
                        break;
                    }
                }
            }
            LOG.debug("isPrincipalMatch(grant={}, request={}): ret={}", new Object[]{this.grant, request, ret});
            return ret;
        }

        private boolean isPermissionMatch(RangerAccessRequest request) {
            boolean ret = StringUtils.isNotBlank((CharSequence)request.getAccessType()) && CollectionUtils.isNotEmpty(this.permissions) && this.permissions.contains(request.getAccessType());
            LOG.debug("isPermissionMatch(grant={}, request={}): ret={}", new Object[]{this.grant, request, ret});
            return ret;
        }

        private boolean isResourceMatch(RangerAccessRequest request) {
            boolean ret = CollectionUtils.isEmpty(this.grant.getResources());
            if (!ret) {
                RangerPolicyResourceMatcher matcher;
                Iterator<RangerPolicyResourceMatcher> iterator = this.resourceMatchers.iterator();
                while (iterator.hasNext() && !(ret = (matcher = iterator.next()).isMatch(request.getResource(), request.getContext()))) {
                }
            }
            LOG.debug("isResourceMatch(grant={}, request={}): ret={}", new Object[]{this.grant, request, ret});
            return ret;
        }
    }
}

