/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ActiveLock {
    private ReentrantReadWriteLock lock;
    private AtomicInteger count;

    private ActiveLock(boolean fairness) {
        this.lock = new ReentrantReadWriteLock(fairness);
        this.count = new AtomicInteger(0);
    }

    public static ActiveLock newInstance(boolean fairness) {
        return new ActiveLock(fairness);
    }

    void readLock() {
        this.lock.readLock().lock();
    }

    void readUnlock() {
        this.lock.readLock().unlock();
    }

    void writeLock() {
        this.lock.writeLock().lock();
    }

    void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    void incrementActiveCount() {
        this.count.incrementAndGet();
    }

    void decrementActiveCount() {
        this.count.decrementAndGet();
    }

    int getActiveLockCount() {
        return this.count.get();
    }

    int getReadHoldCount() {
        return this.lock.getReadHoldCount();
    }

    int getWriteHoldCount() {
        return this.lock.getWriteHoldCount();
    }

    boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    void resetCounter() {
        this.count.set(0);
    }

    public String toString() {
        return this.lock.toString();
    }
}

