/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.slf4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SignalLogger {
    INSTANCE;

    private static final String[] SIGNALS;
    private boolean registered = false;

    public void register(Logger log) {
        if (this.registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        this.registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String separator = "";
        for (String signalName : SIGNALS) {
            try {
                new Handler(signalName, log);
                bld.append(separator).append(signalName);
                separator = ", ";
            }
            catch (Exception e) {
                log.debug("", (Throwable)e);
            }
        }
        bld.append("]");
        if (log.isInfoEnabled()) {
            log.info(bld.toString());
        }
    }

    static {
        SIGNALS = new String[]{"TERM", "HUP", "INT"};
    }

    private static class Handler
    implements SignalHandler {
        private final Logger log;
        private final SignalHandler prevHandler;

        Handler(String name, Logger log) {
            this.log = log;
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            this.log.error("RECEIVED SIGNAL {}: SIG{}", (Object)signal.getNumber(), (Object)signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

