/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ReloadingX509TrustManager
implements X509TrustManager {
    public static final Logger LOG = LoggerFactory.getLogger(ReloadingX509TrustManager.class);
    static final String RELOAD_ERROR_MESSAGE = "Could not reload truststore (keep using existing one) : ";
    private final String type;
    private final AtomicReference<X509TrustManager> trustManagerRef;
    private List<String> currentRootCACertIds = new ArrayList<String>();
    private static final X509Certificate[] EMPTY = new X509Certificate[0];

    public ReloadingX509TrustManager(String type, CertificateClient caClient) throws GeneralSecurityException, IOException {
        this.type = type;
        this.trustManagerRef = new AtomicReference();
        this.trustManagerRef.set(this.loadTrustManager(caClient));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                LOG.info("Client certificate chain {} for authType {} is not trusted", (Object)(chain == null ? "" : Arrays.stream(chain).map(X509Certificate::getSubjectX500Principal).map(X500Principal::toString).collect(Collectors.joining(","))), (Object)authType);
                throw e;
            }
        } else {
            throw new CertificateException("Unknown client chain certificate: " + chain[0].toString());
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                LOG.info("Client certificate chain {} for authType {} is not trusted", (Object)(chain == null ? "" : Arrays.stream(chain).map(X509Certificate::getSubjectX500Principal).map(X500Principal::toString).collect(Collectors.joining(","))), (Object)authType);
                throw e;
            }
        } else {
            throw new CertificateException("Unknown server chain certificate: " + chain[0].toString());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = EMPTY;
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            issuers = tm.getAcceptedIssuers();
        }
        return issuers;
    }

    public ReloadingX509TrustManager loadFrom(CertificateClient caClient) {
        try {
            X509TrustManager manager = this.loadTrustManager(caClient);
            if (manager != null) {
                this.trustManagerRef.set(manager);
                LOG.info("ReloadingX509TrustManager is reloaded.");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(RELOAD_ERROR_MESSAGE, ex);
        }
        return this;
    }

    X509TrustManager loadTrustManager(CertificateClient caClient) throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        Set<X509Certificate> rootCACerts;
        Set<X509Certificate> certList = caClient.getAllRootCaCerts();
        Set<X509Certificate> set = rootCACerts = certList.isEmpty() ? caClient.getAllCaCerts() : certList;
        if (rootCACerts.size() > 0 && this.currentRootCACertIds.size() == rootCACerts.size() && rootCACerts.stream().allMatch(c -> this.currentRootCACertIds.contains(c.getSerialNumber().toString()))) {
            return null;
        }
        X509TrustManager trustManager = null;
        KeyStore ks = KeyStore.getInstance(this.type);
        ks.load(null, null);
        this.insertCertsToKeystore(rootCACerts, ks);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        for (TrustManager trustManager1 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager1 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager1;
            break;
        }
        this.currentRootCACertIds.clear();
        rootCACerts.forEach(c -> this.currentRootCACertIds.add(c.getSerialNumber().toString()));
        return trustManager;
    }

    private void insertCertsToKeystore(Iterable<X509Certificate> certs, KeyStore ks) throws KeyStoreException {
        LOG.info("Trust manager is loaded with certificates");
        for (X509Certificate certToInsert : certs) {
            String certId = certToInsert.getSerialNumber().toString();
            ks.setCertificateEntry(certId, certToInsert);
            LOG.info(certToInsert.toString());
        }
    }
}

