/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.Slices;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public final class VarcharType
extends AbstractVariableWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.builder(Slice.class).addOperators(DEFAULT_READ_OPERATORS).addOperators(DEFAULT_COMPARABLE_OPERATORS).addOperators(DEFAULT_ORDERING_OPERATORS).build();
    public static final int UNBOUNDED_LENGTH = Integer.MAX_VALUE;
    public static final int MAX_LENGTH = 0x7FFFFFFE;
    public static final VarcharType VARCHAR = new VarcharType(Integer.MAX_VALUE);
    private static final VarcharType[] CACHED_INSTANCES = new VarcharType[128];
    private final int length;
    private volatile Optional<Type.Range> range;

    public static VarcharType createUnboundedVarcharType() {
        return VARCHAR;
    }

    public static VarcharType createVarcharType(int length) {
        if (length > 0x7FFFFFFE || length < 0) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        if (length < CACHED_INSTANCES.length) {
            return CACHED_INSTANCES[length];
        }
        return new VarcharType(length);
    }

    private VarcharType(int length) {
        super(new TypeSignature("varchar", Collections.singletonList(TypeSignatureParameter.numericParameter(length))), Slice.class);
        if (length < 0) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        this.length = length;
    }

    public Optional<Integer> getLength() {
        if (this.isUnbounded()) {
            return Optional.empty();
        }
        return Optional.of(this.length);
    }

    public int getBoundedLength() {
        if (this.isUnbounded()) {
            throw new IllegalStateException("Cannot get size of unbounded VARCHAR.");
        }
        return this.length;
    }

    public boolean isUnbounded() {
        return this.length == Integer.MAX_VALUE;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = this.getSlice(block, position);
        if (!this.isUnbounded() && SliceUtf8.countCodePoints((Slice)slice) > this.length) {
            throw new IllegalArgumentException(String.format("Character count exceeds length limit %s: %s", this.length, Slices.sliceRepresentation(slice)));
        }
        return slice.toStringUtf8();
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getLength().map(length -> Math.min(length, 32)).orElse(32));
    }

    @Override
    public Optional<Type.Range> getRange() {
        boolean cachedRangePresent;
        Optional<Type.Range> range = this.range;
        boolean bl = cachedRangePresent = range != null;
        if (!cachedRangePresent) {
            if (this.length > 100) {
                range = Optional.empty();
            } else {
                int codePointSize = SliceUtf8.lengthOfCodePoint((int)0x10FFFF);
                Slice max = io.airlift.slice.Slices.allocate((int)(codePointSize * this.length));
                int position = 0;
                for (int i = 0; i < this.length; ++i) {
                    position += SliceUtf8.setCodePointAt((int)0x10FFFF, (Slice)max, (int)position);
                }
                range = Optional.of(new Type.Range(io.airlift.slice.Slices.EMPTY_SLICE, max));
            }
            this.range = range;
        }
        return range;
    }

    @Override
    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, io.airlift.slice.Slices.utf8Slice((String)value));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarcharType other = (VarcharType)o;
        return this.length == other.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length);
    }

    static {
        for (int i = 0; i < CACHED_INSTANCES.length; ++i) {
            VarcharType.CACHED_INSTANCES[i] = new VarcharType(i);
        }
    }
}

