/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.resourcegroups;

import io.trino.spi.session.ResourceEstimates;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public final class SelectionCriteria {
    private final boolean authenticated;
    private final String user;
    private final Set<String> userGroups;
    private final Optional<String> source;
    private final Set<String> clientTags;
    private final ResourceEstimates resourceEstimates;
    private final Optional<String> queryType;

    public SelectionCriteria(boolean authenticated, String user, Set<String> userGroups, Optional<String> source, Set<String> clientTags, ResourceEstimates resourceEstimates, Optional<String> queryType) {
        this.authenticated = authenticated;
        this.user = Objects.requireNonNull(user, "user is null");
        this.userGroups = Objects.requireNonNull(userGroups, "userGroups is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientTags = Set.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Set<String> getTags() {
        return this.clientTags;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public String toString() {
        return new StringJoiner(", ", SelectionCriteria.class.getSimpleName() + "[", "]").add("authenticated=" + this.authenticated).add("user='" + this.user + "'").add("userGroups=" + String.valueOf(this.userGroups)).add("source=" + String.valueOf(this.source)).add("clientTags=" + String.valueOf(this.clientTags)).add("resourceEstimates=" + String.valueOf(this.resourceEstimates)).add("queryType=" + String.valueOf(this.queryType)).toString();
    }
}

