/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConnectorAccessControl {
    default public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateSchema(schemaName);
    }

    default public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        AccessDeniedException.denyDropSchema(schemaName);
    }

    default public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schemaName, newSchemaName);
    }

    default public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        AccessDeniedException.denySetSchemaAuthorization(schemaName, principal);
    }

    default public void checkCanShowSchemas(ConnectorSecurityContext context) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        AccessDeniedException.denyShowCreateSchema(schemaName);
    }

    default public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyShowCreateTable(tableName.toString(), null);
    }

    default public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateTable(tableName.toString());
    }

    default public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable(tableName.toString());
    }

    default public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable(tableName.toString(), newTableName.toString());
    }

    default public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetTableProperties(tableName.toString());
    }

    default public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCommentTable(tableName.toString());
    }

    default public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyCommentView(viewName.toString());
    }

    default public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCommentColumn(tableName.toString());
    }

    default public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
        AccessDeniedException.denyShowTables(schemaName);
    }

    default public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyShowColumns(tableName.getTableName());
    }

    default public Map<SchemaTableName, Set<String>> filterColumns(ConnectorSecurityContext context, Map<SchemaTableName, Set<String>> tableColumns) {
        return Collections.emptyMap();
    }

    default public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn(tableName.toString());
    }

    default public void checkCanAlterColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyAlterColumn(tableName.toString());
    }

    default public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropColumn(tableName.toString());
    }

    default public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        AccessDeniedException.denySetTableAuthorization(tableName.toString(), principal);
    }

    default public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn(tableName.toString());
    }

    default public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denySelectColumns(tableName.toString(), columnNames);
    }

    default public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable(tableName.toString());
    }

    default public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable(tableName.toString());
    }

    default public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyTruncateTable(tableName.toString());
    }

    default public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        AccessDeniedException.denyUpdateTableColumns(tableName.toString(), updatedColumns);
    }

    default public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView(viewName.toString());
    }

    default public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        AccessDeniedException.denyRenameView(viewName.toString(), newViewName.toString());
    }

    default public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        AccessDeniedException.denySetViewAuthorization(viewName.toString(), principal);
    }

    default public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyDropView(viewName.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect(tableName.toString(), context.getIdentity());
    }

    default public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateMaterializedView(materializedViewName.toString());
    }

    default public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        AccessDeniedException.denyRefreshMaterializedView(materializedViewName.toString());
    }

    default public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetMaterializedViewProperties(materializedViewName.toString());
    }

    default public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        AccessDeniedException.denyDropMaterializedView(materializedViewName.toString());
    }

    default public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        AccessDeniedException.denyRenameMaterializedView(viewName.toString(), newViewName.toString());
    }

    default public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantSchemaPrivilege(privilege.toString(), schemaName);
    }

    default public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenySchemaPrivilege(privilege.toString(), schemaName);
    }

    default public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeSchemaPrivilege(privilege.toString(), schemaName);
    }

    default public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole(role);
    }

    default public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        AccessDeniedException.denyDropRole(role);
    }

    default public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    default public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    default public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        AccessDeniedException.denySetRole(role);
    }

    default public void checkCanShowRoles(ConnectorSecurityContext context) {
        AccessDeniedException.denyShowRoles();
    }

    default public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
        AccessDeniedException.denyShowCurrentRoles();
    }

    default public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
        AccessDeniedException.denyShowRoleGrants();
    }

    default public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
        AccessDeniedException.denyExecuteProcedure(procedure.toString());
    }

    default public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
        AccessDeniedException.denyExecuteTableProcedure(tableName.toString(), procedure);
    }

    default public boolean canExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return false;
    }

    default public boolean canCreateViewWithExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return false;
    }

    default public void checkCanShowFunctions(ConnectorSecurityContext context, String schemaName) {
        AccessDeniedException.denyShowFunctions(schemaName);
    }

    default public Set<SchemaFunctionName> filterFunctions(ConnectorSecurityContext context, Set<SchemaFunctionName> functionNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        AccessDeniedException.denyCreateFunction(function.toString());
    }

    default public void checkCanDropFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        AccessDeniedException.denyDropFunction(function.toString());
    }

    default public void checkCanShowCreateFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        AccessDeniedException.denyShowCreateFunction(function.toString());
    }

    default public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        return Collections.emptyList();
    }

    default public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }
}

