/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntervalDayTime {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final String LONG_MIN_VALUE = "-106751991167 07:12:55.808";
    private static final Pattern FORMAT = Pattern.compile("(\\d+) (\\d+):(\\d+):(\\d+).(\\d+)");

    private IntervalDayTime() {
    }

    public static long toMillis(long day, long hour, long minute, long second, long millis) {
        try {
            long value = millis;
            value = Math.addExact(value, Math.multiplyExact(day, 86400000L));
            value = Math.addExact(value, Math.multiplyExact(hour, 3600000L));
            value = Math.addExact(value, Math.multiplyExact(minute, 60000L));
            value = Math.addExact(value, Math.multiplyExact(second, 1000L));
            return value;
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String formatMillis(long millis) {
        if (millis == Long.MIN_VALUE) {
            return LONG_MIN_VALUE;
        }
        String sign = "";
        if (millis < 0L) {
            sign = "-";
            millis = -millis;
        }
        long day = millis / 86400000L;
        long hour = (millis %= 86400000L) / 3600000L;
        long minute = (millis %= 3600000L) / 60000L;
        long second = (millis %= 60000L) / 1000L;
        return String.format("%s%d %02d:%02d:%02d.%03d", sign, day, hour, minute, second, millis %= 1000L);
    }

    public static long parseMillis(String value) {
        Matcher matcher;
        if (value.equals(LONG_MIN_VALUE)) {
            return Long.MIN_VALUE;
        }
        long signum = 1L;
        if (value.startsWith("-")) {
            signum = -1L;
            value = value.substring(1);
        }
        if (!(matcher = FORMAT.matcher(value)).matches()) {
            throw new IllegalArgumentException("Invalid day-time interval: " + value);
        }
        long days = Long.parseLong(matcher.group(1));
        long hours = Long.parseLong(matcher.group(2));
        long minutes = Long.parseLong(matcher.group(3));
        long seconds = Long.parseLong(matcher.group(4));
        long millis = Long.parseLong(matcher.group(5));
        return IntervalDayTime.toMillis(days, hours, minutes, seconds, millis) * signum;
    }
}

