/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.namequeues.MetricsWALEventTrackerSource;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerTableAccessor;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALEventTrackerQueueService
implements NamedQueueService {
    private EvictingQueue<WALEventTrackerPayload> queue;
    private static final String WAL_EVENT_TRACKER_RING_BUFFER_SIZE = "hbase.regionserver.wal.event.tracker.ringbuffer.size";
    private final boolean walEventTrackerEnabled;
    private int queueSize;
    private MetricsWALEventTrackerSource source = null;
    private static final Logger LOG = LoggerFactory.getLogger(WALEventTrackerQueueService.class);

    public WALEventTrackerQueueService(Configuration conf) {
        this(conf, null);
    }

    public WALEventTrackerQueueService(Configuration conf, MetricsWALEventTrackerSource source) {
        this.walEventTrackerEnabled = conf.getBoolean("hbase.regionserver.wal.event.tracker.enabled", false);
        if (!this.walEventTrackerEnabled) {
            return;
        }
        this.queueSize = conf.getInt(WAL_EVENT_TRACKER_RING_BUFFER_SIZE, 256);
        this.queue = EvictingQueue.create((int)this.queueSize);
        this.source = source == null ? (MetricsWALEventTrackerSource)CompatibilitySingletonFactory.getInstance(MetricsWALEventTrackerSource.class) : source;
    }

    @Override
    public NamedQueuePayload.NamedQueueEvent getEvent() {
        return NamedQueuePayload.NamedQueueEvent.WAL_EVENT_TRACKER;
    }

    @Override
    public void consumeEventFromDisruptor(NamedQueuePayload namedQueuePayload) {
        if (!this.walEventTrackerEnabled) {
            return;
        }
        if (!(namedQueuePayload instanceof WALEventTrackerPayload)) {
            LOG.warn("WALEventTrackerQueueService: NamedQueuePayload is not of type WALEventTrackerPayload.");
            return;
        }
        WALEventTrackerPayload payload = (WALEventTrackerPayload)namedQueuePayload;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding wal event tracker payload " + payload);
        }
        this.addToQueue(payload);
    }

    synchronized void addToQueue(WALEventTrackerPayload payload) {
        this.queue.add((Object)payload);
    }

    @Override
    public boolean clearNamedQueue() {
        if (!this.walEventTrackerEnabled) {
            return false;
        }
        LOG.debug("Clearing wal event tracker queue");
        this.queue.clear();
        return true;
    }

    @Override
    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return null;
    }

    @Override
    public void persistAll(Connection connection) {
        if (!this.walEventTrackerEnabled) {
            return;
        }
        if (this.queue.isEmpty()) {
            LOG.debug("Wal Event tracker queue is empty.");
            return;
        }
        Queue<WALEventTrackerPayload> queue = this.getWALEventTrackerList();
        try {
            WALEventTrackerTableAccessor.addWalEventTrackerRows(queue, connection);
        }
        catch (Exception ioe) {
            LOG.error("Failed while persisting wal tracker records", (Throwable)ioe);
            this.source.incrFailedPuts((long)queue.size());
        }
    }

    private synchronized Queue<WALEventTrackerPayload> getWALEventTrackerList() {
        ArrayDeque<WALEventTrackerPayload> retQueue = new ArrayDeque<WALEventTrackerPayload>();
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            retQueue.add((WALEventTrackerPayload)iterator.next());
        }
        this.queue.clear();
        return retQueue;
    }
}

