/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections;
using Apache.Qpid.Proton.Test.Driver.Codec.Primitives;

namespace Apache.Qpid.Proton.Test.Driver.Codec.Transactions
{
   public enum CoordinatorField
   {
      Capabilities
   }

   public sealed class Coordinator : ListDescribedType
   {
      public static readonly Symbol DESCRIPTOR_SYMBOL = new("amqp:coordinator:list");
      public static readonly ulong DESCRIPTOR_CODE = 0x0000000000000030ul;

      public Coordinator() : base(Enum.GetNames(typeof(CoordinatorField)).Length)
      {
      }

      public Coordinator(object described) : base(Enum.GetNames(typeof(CoordinatorField)).Length, (IList)described)
      {
      }

      public Coordinator(Coordinator value) : base(Enum.GetNames(typeof(CoordinatorField)).Length, value)
      {
      }

      public Coordinator(IList described) : base(Enum.GetNames(typeof(CoordinatorField)).Length, described)
      {
      }

      public override object Descriptor => DESCRIPTOR_SYMBOL;

      public Symbol[] Capabilities
      {
         get => (Symbol[])List[((int)CoordinatorField.Capabilities)];
         set => List[((int)CoordinatorField.Capabilities)] = value;
      }

      public override string ToString()
      {
         return "Coordinator{" + "capabilities=" + Capabilities + '}';
      }
   }
}