/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawBatchConverter;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.compaction.AbstractTwoPhaseCompactor;
import org.apache.pulsar.compaction.MessageCompactionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTimeOrderCompactor
extends AbstractTwoPhaseCompactor<Pair<MessageId, Long>> {
    private static final Logger log = LoggerFactory.getLogger(EventTimeOrderCompactor.class);

    public EventTimeOrderCompactor(ServiceConfiguration conf, PulsarClient pulsar, BookKeeper bk, ScheduledExecutorService scheduler) {
        super(conf, pulsar, bk, scheduler);
    }

    @Override
    protected Map<String, MessageId> toLatestMessageIdForKey(Map<String, Pair<MessageId, Long>> latestForKey) {
        return latestForKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (MessageId)((Pair)entry.getValue()).getLeft()));
    }

    @Override
    protected boolean compactMessage(String topic, Map<String, Pair<MessageId, Long>> latestForKey, RawMessage m, MessageMetadata metadata, MessageId id) {
        boolean deletedMessage = false;
        boolean replaceMessage = false;
        MessageCompactionData mcd = this.extractMessageCompactionData(m, metadata);
        if (mcd != null) {
            boolean newer = Optional.ofNullable(latestForKey.get(mcd.key())).map(Pair::getRight).map(latestEventTime -> mcd.eventTime() != null && mcd.eventTime() >= latestEventTime).orElse(true);
            if (newer) {
                if (mcd.payloadSize() > 0) {
                    Pair<MessageId, Long> old = latestForKey.put(mcd.key(), (Pair<MessageId, Long>)new ImmutablePair((Object)mcd.messageId(), (Object)mcd.eventTime()));
                    replaceMessage = old != null;
                } else {
                    deletedMessage = true;
                    latestForKey.remove(mcd.key());
                }
            }
        } else if (!this.topicCompactionRetainNullKey) {
            deletedMessage = true;
        }
        if (replaceMessage || deletedMessage) {
            this.mxBean.addCompactionRemovedEvent(topic);
        }
        return deletedMessage;
    }

    @Override
    protected boolean compactBatchMessage(String topic, Map<String, Pair<MessageId, Long>> latestForKey, RawMessage m, MessageMetadata metadata, MessageId id) {
        boolean deletedMessage = false;
        try {
            int numMessagesInBatch = metadata.getNumMessagesInBatch();
            int deleteCnt = 0;
            for (MessageCompactionData mcd : this.extractMessageCompactionDataFromBatch(m, metadata)) {
                if (mcd.key() == null) {
                    if (this.topicCompactionRetainNullKey) continue;
                    ++deleteCnt;
                    this.mxBean.addCompactionRemovedEvent(topic);
                    continue;
                }
                boolean newer = Optional.ofNullable(latestForKey.get(mcd.key())).map(Pair::getRight).map(latestEventTime -> mcd.eventTime() != null && mcd.eventTime() > latestEventTime).orElse(true);
                if (!newer) continue;
                if (mcd.payloadSize() > 0) {
                    Pair<MessageId, Long> old = latestForKey.put(mcd.key(), (Pair<MessageId, Long>)new ImmutablePair((Object)mcd.messageId(), (Object)mcd.eventTime()));
                    if (old == null) continue;
                    this.mxBean.addCompactionRemovedEvent(topic);
                    continue;
                }
                latestForKey.remove(mcd.key());
                ++deleteCnt;
                this.mxBean.addCompactionRemovedEvent(topic);
            }
            if (deleteCnt == numMessagesInBatch) {
                deletedMessage = true;
            }
        }
        catch (IOException ioe) {
            log.info("Error decoding batch for message {}. Whole batch will be included in output", (Object)id, (Object)ioe);
        }
        return deletedMessage;
    }

    protected MessageCompactionData extractMessageCompactionData(RawMessage m, MessageMetadata metadata) {
        ByteBuf headersAndPayload = m.getHeadersAndPayload();
        if (metadata.hasPartitionKey()) {
            int size = headersAndPayload.readableBytes();
            if (metadata.hasUncompressedSize()) {
                size = metadata.getUncompressedSize();
            }
            return new MessageCompactionData(m.getMessageId(), metadata.getPartitionKey(), size, metadata.getEventTime());
        }
        return null;
    }

    private List<MessageCompactionData> extractMessageCompactionDataFromBatch(RawMessage msg, MessageMetadata metadata) throws IOException {
        return RawBatchConverter.extractMessageCompactionData(msg, metadata);
    }
}

