/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.protocol;

import java.io.Serializable;
import java.util.Comparator;

public class RangeId
implements Comparable<RangeId>,
Serializable {
    public static final Comparator<RangeId> COMPARATOR = Comparator.naturalOrder();
    private static final long serialVersionUID = 1704491294262309389L;
    private final long streamId;
    private final long rangeId;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("range(").append(this.streamId).append(", ").append(this.rangeId).append(')');
        return sb.toString();
    }

    @Override
    public int compareTo(RangeId other) {
        int result = Long.compare(this.streamId, other.streamId);
        if (result == 0) {
            result = Long.compare(this.rangeId, other.rangeId);
        }
        return result;
    }

    private RangeId(long streamId, long rangeId) {
        this.streamId = streamId;
        this.rangeId = rangeId;
    }

    public static RangeId of(long streamId, long rangeId) {
        return new RangeId(streamId, rangeId);
    }

    public long getStreamId() {
        return this.streamId;
    }

    public long getRangeId() {
        return this.rangeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeId)) {
            return false;
        }
        RangeId other = (RangeId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        return this.getRangeId() == other.getRangeId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RangeId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $streamId = this.getStreamId();
        result = result * 59 + (int)($streamId >>> 32 ^ $streamId);
        long $rangeId = this.getRangeId();
        result = result * 59 + (int)($rangeId >>> 32 ^ $rangeId);
        return result;
    }
}

