/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.stats.prometheus.ScopeContext;

public class ThreadScopedLongAdderCounter
implements Counter {
    private ThreadLocal<LongAdderCounter> counters;
    private LongAdderCounter defaultCounter;
    private Map<String, String> originalLabels;
    private ScopeContext scopeContext;
    private PrometheusMetricsProvider provider;

    public ThreadScopedLongAdderCounter(PrometheusMetricsProvider provider, ScopeContext scopeContext, Map<String, String> labels) {
        this.provider = provider;
        this.scopeContext = scopeContext;
        this.originalLabels = new HashMap<String, String>(labels);
        this.defaultCounter = new LongAdderCounter(labels);
        HashMap<String, String> defaultLabels = new HashMap<String, String>(labels);
        defaultLabels.put("threadPool", "?");
        defaultLabels.put("thread", "?");
        this.defaultCounter.initializeThread(defaultLabels);
        this.counters = ThreadLocal.withInitial(() -> new LongAdderCounter(labels));
    }

    public void clear() {
        this.getCounter().clear();
    }

    public void inc() {
        this.getCounter().inc();
    }

    public void dec() {
        this.getCounter().dec();
    }

    public void addCount(long delta) {
        this.getCounter().addCount(delta);
    }

    public void addLatency(long eventLatency, TimeUnit unit) {
        this.getCounter().addLatency(eventLatency, unit);
    }

    public Long get() {
        return this.getCounter().get();
    }

    private LongAdderCounter getCounter() {
        LongAdderCounter counter = this.counters.get();
        if (!counter.isThreadInitialized()) {
            ThreadRegistry.ThreadPoolThread tpt = ThreadRegistry.get();
            if (tpt == null) {
                this.counters.set(this.defaultCounter);
                this.provider.counters.put(new ScopeContext(this.scopeContext.getScope(), this.originalLabels), this.defaultCounter);
                return this.defaultCounter;
            }
            HashMap<String, String> threadScopedlabels = new HashMap<String, String>(this.originalLabels);
            threadScopedlabels.put("threadPool", tpt.getThreadPool());
            threadScopedlabels.put("thread", String.valueOf(tpt.getOrdinal()));
            counter.initializeThread(threadScopedlabels);
            this.provider.counters.put(new ScopeContext(this.scopeContext.getScope(), threadScopedlabels), counter);
        }
        return counter;
    }
}

