/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Optional;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.AckSetState;

public class AckSetPositionImpl
implements Position,
AckSetState {
    private final Optional<AckSetState> ackSetStateExtension = Optional.of(this);
    protected final long ledgerId;
    protected final long entryId;
    protected volatile long[] ackSet;

    public AckSetPositionImpl(long ledgerId, long entryId, long[] ackSet) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.ackSet = ackSet;
    }

    @Override
    public long[] getAckSet() {
        return this.ackSet;
    }

    @Override
    public void setAckSet(long[] ackSet) {
        this.ackSet = ackSet;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public Position getNext() {
        if (this.entryId < 0L) {
            return PositionFactory.create(this.ledgerId, 0L);
        }
        return PositionFactory.create(this.ledgerId, this.entryId + 1L);
    }

    public String toString() {
        return this.ledgerId + ":" + this.entryId + " (ackSet " + (String)(this.ackSet == null ? "is null" : "with long[] size of " + this.ackSet.length) + ")";
    }

    public int hashCode() {
        return this.hashCodeForPosition();
    }

    public boolean equals(Object obj) {
        return obj instanceof Position && this.compareTo((Position)obj) == 0;
    }

    @Override
    public <T> Optional<T> getExtension(Class<T> extensionClass) {
        if (extensionClass == AckSetState.class) {
            return this.ackSetStateExtension;
        }
        return Position.super.getExtension(extensionClass);
    }
}

