/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;

class ReadCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.ReadEntryCallback cb;

    public ReadCompletion(CompletionKey key, BookkeeperInternalCallbacks.ReadEntryCallback originalCallback, Object originalCtx, long ledgerId, long entryId, PerChannelBookieClient perChannelBookieClient) {
        super("Read", originalCtx, ledgerId, entryId, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.readEntryOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.readTimeoutOpLogger;
        this.cb = (rc, ledgerId1, entryId1, buffer, ctx) -> {
            this.logOpResult(rc);
            originalCallback.readEntryComplete(rc, ledgerId1, entryId1, buffer, originalCtx);
            key.release();
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.readEntryComplete(rc, this.ledgerId, this.entryId, null, this.ctx));
    }

    @Override
    public void setOutstanding() {
        this.perChannelBookieClient.readEntryOutstanding.inc();
    }

    @Override
    public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
        this.perChannelBookieClient.readEntryOutstanding.dec();
        if (!(response instanceof BookieProtocol.ReadResponse)) {
            return;
        }
        BookieProtocol.ReadResponse readResponse = (BookieProtocol.ReadResponse)response;
        this.handleReadResponse(ledgerId, entryId, status, readResponse.getData(), -1L, -1L);
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        this.perChannelBookieClient.readEntryOutstanding.dec();
        BookkeeperProtocol.ReadResponse readResponse = response.getReadResponse();
        BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readResponse.getStatus() : response.getStatus();
        ByteBuf buffer = Unpooled.EMPTY_BUFFER;
        if (readResponse.hasBody()) {
            buffer = Unpooled.wrappedBuffer((ByteBuffer)readResponse.getBody().asReadOnlyByteBuffer());
        }
        long maxLAC = -1L;
        if (readResponse.hasMaxLAC()) {
            maxLAC = readResponse.getMaxLAC();
        }
        long lacUpdateTimestamp = -1L;
        if (readResponse.hasLacUpdateTimestamp()) {
            lacUpdateTimestamp = readResponse.getLacUpdateTimestamp();
        }
        this.handleReadResponse(readResponse.getLedgerId(), readResponse.getEntryId(), status, buffer, maxLAC, lacUpdateTimestamp);
        ReferenceCountUtil.release((Object)buffer);
    }

    private void handleReadResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, ByteBuf buffer, long maxLAC, long lacUpdateTimestamp) {
        int readableBytes = buffer.readableBytes();
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledger", ledgerId, "entry", entryId, "entryLength", readableBytes);
        }
        int rc = this.convertStatus(status, -1);
        if (maxLAC > -1L && this.ctx instanceof BookkeeperInternalCallbacks.ReadEntryCallbackCtx) {
            ((BookkeeperInternalCallbacks.ReadEntryCallbackCtx)this.ctx).setLastAddConfirmed(maxLAC);
        }
        if (lacUpdateTimestamp > -1L && this.ctx instanceof ReadLastConfirmedAndEntryContext) {
            ((ReadLastConfirmedAndEntryContext)this.ctx).setLacUpdateTimestamp(lacUpdateTimestamp);
        }
        this.cb.readEntryComplete(rc, ledgerId, entryId, buffer.slice(), this.ctx);
    }
}

