/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.MaxLogSegmentSequenceNo;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.util.DLUtils;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogSegmentsZK
extends TestDistributedLogBase {
    static Logger LOG = LoggerFactory.getLogger(TestLogSegmentsZK.class);
    @Rule
    public TestName testName = new TestName();

    private static MaxLogSegmentSequenceNo getMaxLogSegmentSequenceNo(ZooKeeperClient zkc, URI uri, String streamName, DistributedLogConfiguration conf) throws Exception {
        Stat stat = new Stat();
        String logSegmentsPath = LogMetadata.getLogSegmentsPath((URI)uri, (String)streamName, (String)conf.getUnpartitionedStreamName());
        byte[] data = zkc.get().getData(logSegmentsPath, false, stat);
        Versioned maxLSSNData = new Versioned((Object)data, (Version)new LongVersion((long)stat.getVersion()));
        return new MaxLogSegmentSequenceNo(maxLSSNData);
    }

    private static void updateMaxLogSegmentSequenceNo(ZooKeeperClient zkc, URI uri, String streamName, DistributedLogConfiguration conf, byte[] data) throws Exception {
        String logSegmentsPath = LogMetadata.getLogSegmentsPath((URI)uri, (String)streamName, (String)conf.getUnpartitionedStreamName());
        zkc.get().setData(logSegmentsPath, data, -1);
    }

    private URI createURI() throws Exception {
        return this.createDLMURI("/" + this.testName.getMethodName());
    }

    @Test(timeout=60000L)
    public void testCreateLogSegmentOnPrecreatedStream() throws Exception {
        URI uri = this.createURI();
        String streamName = this.testName.getMethodName();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(99999L).setOutputBufferSize(0).setImmediateFlushEnabled(true).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        namespace.createLog(streamName);
        MaxLogSegmentSequenceNo max1 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)0L, (long)max1.getSequenceNumber());
        DistributedLogManager dlm = namespace.openLog(streamName);
        int numSegments = 3;
        for (int i = 0; i < 3; ++i) {
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(i));
            out.closeAndComplete();
        }
        MaxLogSegmentSequenceNo max2 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)3L, (long)max2.getSequenceNumber());
        dlm.close();
        namespace.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCreateLogSegmentMissingMaxSequenceNumber() throws Exception {
        URI uri = this.createURI();
        String streamName = this.testName.getMethodName();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(99999L).setOutputBufferSize(0).setImmediateFlushEnabled(true).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        namespace.createLog(streamName);
        MaxLogSegmentSequenceNo max1 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)0L, (long)max1.getSequenceNumber());
        DistributedLogManager dlm = namespace.openLog(streamName);
        int numSegments = 3;
        for (int i = 0; i < 3; ++i) {
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(i));
            out.closeAndComplete();
        }
        MaxLogSegmentSequenceNo max2 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)3L, (long)max2.getSequenceNumber());
        TestLogSegmentsZK.updateMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf, new byte[0]);
        try (DistributedLogManager dlm1 = namespace.openLog(streamName);){
            dlm1.startLogSegmentNonPartitioned();
            Assert.fail((String)"Should fail with unexpected exceptions");
        }
        TestLogSegmentsZK.updateMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf, "invalid-max".getBytes(StandardCharsets.UTF_8));
        try (DistributedLogManager dlm2 = namespace.openLog(streamName);){
            dlm2.startLogSegmentNonPartitioned();
            Assert.fail((String)"Should fail with unexpected exceptions");
        }
        dlm.close();
        namespace.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCreateLogSegmentUnmatchMaxSequenceNumber() throws Exception {
        URI uri = this.createURI();
        String streamName = this.testName.getMethodName();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(99999L).setOutputBufferSize(0).setImmediateFlushEnabled(true).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        namespace.createLog(streamName);
        MaxLogSegmentSequenceNo max1 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)0L, (long)max1.getSequenceNumber());
        DistributedLogManager dlm = namespace.openLog(streamName);
        int numSegments = 3;
        for (int i = 0; i < 3; ++i) {
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(i));
            out.closeAndComplete();
        }
        MaxLogSegmentSequenceNo max2 = TestLogSegmentsZK.getMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf);
        Assert.assertEquals((long)3L, (long)max2.getSequenceNumber());
        TestLogSegmentsZK.updateMaxLogSegmentSequenceNo(this.getZooKeeperClient(namespace), uri, streamName, conf, DLUtils.serializeLogSegmentSequenceNumber((long)99L));
        try (DistributedLogManager dlm1 = namespace.openLog(streamName);){
            BKSyncLogWriter out1 = (BKSyncLogWriter)dlm1.startLogSegmentNonPartitioned();
            out1.write(DLMTestUtil.getLogRecordInstance(4L));
            out1.closeAndComplete();
            Assert.fail((String)"Should fail creating new log segment when encountered unmatch max ledger sequence number");
        }
        DistributedLogManager dlm2 = namespace.openLog(streamName);
        List segments = dlm2.getLogSegments();
        try {
            Assert.assertEquals((long)3L, (long)segments.size());
            Assert.assertEquals((long)1L, (long)((LogSegmentMetadata)segments.get(0)).getLogSegmentSequenceNumber());
            Assert.assertEquals((long)2L, (long)((LogSegmentMetadata)segments.get(1)).getLogSegmentSequenceNumber());
            Assert.assertEquals((long)3L, (long)((LogSegmentMetadata)segments.get(2)).getLogSegmentSequenceNumber());
        }
        finally {
            dlm2.close();
        }
        dlm.close();
        namespace.close();
    }

    @Test(timeout=60000L)
    public void testCompleteLogSegmentConflicts() throws Exception {
        URI uri = this.createURI();
        String streamName = this.testName.getMethodName();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(99999L).setOutputBufferSize(0).setImmediateFlushEnabled(true).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        namespace.createLog(streamName);
        DistributedLogManager dlm1 = namespace.openLog(streamName);
        DistributedLogManager dlm2 = namespace.openLog(streamName);
        BKSyncLogWriter out1 = (BKSyncLogWriter)dlm1.startLogSegmentNonPartitioned();
        out1.write(DLMTestUtil.getLogRecordInstance(1L));
        BKAsyncLogWriter out2 = (BKAsyncLogWriter)dlm2.startAsyncLogSegmentNonPartitioned();
        try {
            out1.closeAndComplete();
            Assert.fail((String)"Should fail closeAndComplete since other people already completed it.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

