/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1BoundObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TokenRequestSpec contains client provided parameters of a token request.")
public class V1TokenRequestSpec {
    public static final String SERIALIZED_NAME_AUDIENCES = "audiences";
    @SerializedName(value="audiences")
    private List<String> audiences = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BOUND_OBJECT_REF = "boundObjectRef";
    @SerializedName(value="boundObjectRef")
    private V1BoundObjectReference boundObjectRef;
    public static final String SERIALIZED_NAME_EXPIRATION_SECONDS = "expirationSeconds";
    @SerializedName(value="expirationSeconds")
    private Long expirationSeconds;

    public V1TokenRequestSpec audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1TokenRequestSpec addAudiencesItem(String audiencesItem) {
        this.audiences.add(audiencesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.")
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public V1TokenRequestSpec boundObjectRef(V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef;
    }

    public void setBoundObjectRef(V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
    }

    public V1TokenRequestSpec expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.")
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenRequestSpec v1TokenRequestSpec = (V1TokenRequestSpec)o;
        return Objects.equals(this.audiences, v1TokenRequestSpec.audiences) && Objects.equals(this.boundObjectRef, v1TokenRequestSpec.boundObjectRef) && Objects.equals(this.expirationSeconds, v1TokenRequestSpec.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TokenRequestSpec {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    boundObjectRef: ").append(this.toIndentedString(this.boundObjectRef)).append("\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

