/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PacketProcessorBaseV3
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PacketProcessorBaseV3.class);
    final BookkeeperProtocol.Request request;
    final BookieRequestHandler requestHandler;
    final BookieRequestProcessor requestProcessor;
    final long enqueueNanos;

    public PacketProcessorBaseV3(BookkeeperProtocol.Request request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.requestHandler = requestHandler;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(final BookkeeperProtocol.StatusCode code, Object response, final OpStatsLogger statsLogger) {
        final long writeNanos = MathUtils.nowInNano();
        Channel channel = this.requestHandler.ctx().channel();
        long timeOut = this.requestProcessor.getWaitTimeoutOnBackpressureMillis();
        if (timeOut >= 0L && !channel.isWritable()) {
            if (!this.requestProcessor.isBlacklisted(channel)) {
                Channel channel2 = channel;
                synchronized (channel2) {
                    if (!channel.isWritable() && !this.requestProcessor.isBlacklisted(channel)) {
                        long waitUntilNanos = writeNanos + TimeUnit.MILLISECONDS.toNanos(timeOut);
                        while (!channel.isWritable() && MathUtils.nowInNano() < waitUntilNanos) {
                            try {
                                TimeUnit.MILLISECONDS.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (!channel.isWritable()) {
                            this.requestProcessor.blacklistChannel(channel);
                            this.requestProcessor.handleNonWritableChannel(channel);
                        }
                    }
                }
            }
            if (!channel.isWritable()) {
                log.warn("cannot write response to non-writable channel {} for request {}", (Object)channel, (Object)StringUtils.requestToString(this.request));
                this.requestProcessor.getRequestStats().getChannelWriteStats().registerFailedEvent(MathUtils.elapsedNanos((long)writeNanos), TimeUnit.NANOSECONDS);
                statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
                return;
            }
            this.requestProcessor.invalidateBlacklist(channel);
        }
        if (channel.isActive()) {
            channel.writeAndFlush(response).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    long writeElapsedNanos = MathUtils.elapsedNanos((long)writeNanos);
                    if (!future.isSuccess()) {
                        PacketProcessorBaseV3.this.requestProcessor.getRequestStats().getChannelWriteStats().registerFailedEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                    } else {
                        PacketProcessorBaseV3.this.requestProcessor.getRequestStats().getChannelWriteStats().registerSuccessfulEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                    }
                    if (BookkeeperProtocol.StatusCode.EOK == code) {
                        statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                    } else {
                        statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                    }
                }
            });
        } else {
            log.debug("Netty channel {} is inactive, hence bypassing netty channel writeAndFlush during sendResponse", (Object)channel);
        }
    }

    protected boolean isVersionCompatible() {
        return this.request.getHeader().getVersion().equals((Object)BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
    }

    protected BookkeeperProtocol.BKPacketHeader getHeader() {
        BookkeeperProtocol.BKPacketHeader.Builder header = BookkeeperProtocol.BKPacketHeader.newBuilder();
        header.setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
        header.setOperation(this.request.getHeader().getOperation());
        header.setTxnId(this.request.getHeader().getTxnId());
        return header.build();
    }

    public String toString() {
        return this.request.toString();
    }
}

