/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Joiner;
import lombok.Generated;
import org.apache.pulsar.websocket.WebSocketError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProducerAck {
    public String result;
    public String errorMsg;
    public String messageId;
    public String context;
    public int errorCode;
    public long schemaVersion;

    public ProducerAck(String messageId, String context) {
        this.result = "ok";
        this.messageId = messageId;
        this.context = context;
    }

    public ProducerAck(WebSocketError error, String errorMsg, String messageId, String context) {
        this.result = Joiner.on((char)':').join((Object)"send-error", (Object)error.getCode(), new Object[0]);
        this.errorMsg = errorMsg;
        this.messageId = messageId;
        this.context = context;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setSchemaVersion(long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerAck)) {
            return false;
        }
        ProducerAck other = (ProducerAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        if (this.getSchemaVersion() != other.getSchemaVersion()) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProducerAck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrorCode();
        long $schemaVersion = this.getSchemaVersion();
        result = result * 59 + (int)($schemaVersion >>> 32 ^ $schemaVersion);
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProducerAck(result=" + this.getResult() + ", errorMsg=" + this.getErrorMsg() + ", messageId=" + this.getMessageId() + ", context=" + this.getContext() + ", errorCode=" + this.getErrorCode() + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    @Generated
    public ProducerAck() {
    }

    @Generated
    public ProducerAck(String result, String errorMsg, String messageId, String context, int errorCode, long schemaVersion) {
        this.result = result;
        this.errorMsg = errorMsg;
        this.messageId = messageId;
        this.context = context;
        this.errorCode = errorCode;
        this.schemaVersion = schemaVersion;
    }
}

