/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarZooKeeperClient
extends ZooKeeper
implements Watcher,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarZooKeeperClient.class);
    private static final int DEFAULT_RETRY_EXECUTOR_THREAD_COUNT = 1;
    private final String connectString;
    private final int sessionTimeoutMs;
    private final boolean allowReadOnlyMode;
    private final AtomicReference<ZooKeeper> zk = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ZooKeeperWatcherBase watcherManager;
    private final ScheduledExecutorService retryExecutor;
    private final ExecutorService connectExecutor;
    private final RateLimiter rateLimiter;
    private final RetryPolicy connectRetryPolicy;
    private final RetryPolicy operationRetryPolicy;
    private final OpStatsLogger createStats;
    private final OpStatsLogger getStats;
    private final OpStatsLogger setStats;
    private final OpStatsLogger deleteStats;
    private final OpStatsLogger getChildrenStats;
    private final OpStatsLogger existsStats;
    private final OpStatsLogger multiStats;
    private final OpStatsLogger getACLStats;
    private final OpStatsLogger setACLStats;
    private final OpStatsLogger syncStats;
    private final OpStatsLogger createClientStats;
    private final Runnable clientCreator = new Runnable(){

        @Override
        public void run() {
            try {
                ZooWorker.syncCallWithRetries(null, new ZooWorker.ZooCallable<ZooKeeper>(){

                    @Override
                    public ZooKeeper call() throws KeeperException, InterruptedException {
                        ZooKeeper newZk;
                        log.info("Reconnecting zookeeper {}.", (Object)PulsarZooKeeperClient.this.connectString);
                        PulsarZooKeeperClient.this.closeZkHandle();
                        try {
                            newZk = PulsarZooKeeperClient.this.createZooKeeper();
                        }
                        catch (IOException ie) {
                            log.error("Failed to create zookeeper instance to " + PulsarZooKeeperClient.this.connectString, (Throwable)ie);
                            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
                        }
                        PulsarZooKeeperClient.this.waitForConnection();
                        PulsarZooKeeperClient.this.zk.set(newZk);
                        log.info("ZooKeeper session {} is created to {}.", (Object)Long.toHexString(newZk.getSessionId()), (Object)PulsarZooKeeperClient.this.connectString);
                        return newZk;
                    }

                    public String toString() {
                        return String.format("ZooKeeper Client Creator (%s)", PulsarZooKeeperClient.this.connectString);
                    }
                }, PulsarZooKeeperClient.this.connectRetryPolicy, PulsarZooKeeperClient.this.rateLimiter, PulsarZooKeeperClient.this.createClientStats);
            }
            catch (Exception e) {
                log.error("Gave up reconnecting to ZooKeeper : ", (Throwable)e);
                Runtime.getRuntime().exit(1);
            }
        }
    };

    @VisibleForTesting
    static PulsarZooKeeperClient createConnectedZooKeeperClient(String connectString, int sessionTimeoutMs, Set<Watcher> childWatchers, RetryPolicy operationRetryPolicy) throws KeeperException, InterruptedException, IOException {
        return PulsarZooKeeperClient.newBuilder().connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).watchers(childWatchers).operationRetryPolicy(operationRetryPolicy).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected PulsarZooKeeperClient(String connectString, int sessionTimeoutMs, ZooKeeperWatcherBase watcherManager, RetryPolicy connectRetryPolicy, RetryPolicy operationRetryPolicy, StatsLogger statsLogger, int retryExecThreadCount, double rate, boolean allowReadOnlyMode) throws IOException {
        super(connectString, sessionTimeoutMs, (Watcher)watcherManager, allowReadOnlyMode);
        this.connectString = connectString;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.allowReadOnlyMode = allowReadOnlyMode;
        this.watcherManager = watcherManager;
        this.connectRetryPolicy = connectRetryPolicy;
        this.operationRetryPolicy = operationRetryPolicy;
        this.rateLimiter = rate > 0.0 ? RateLimiter.create((double)rate) : null;
        this.retryExecutor = Executors.newScheduledThreadPool(retryExecThreadCount, new ThreadFactoryBuilder().setNameFormat("ZKC-retry-executor-%d").build());
        this.connectExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ZKC-connect-executor-%d").build());
        watcherManager.addChildWatcher((Watcher)this);
        StatsLogger scopedStatsLogger = statsLogger.scope("zk");
        this.createClientStats = scopedStatsLogger.getOpStatsLogger("create_client");
        this.createStats = scopedStatsLogger.getOpStatsLogger("create");
        this.getStats = scopedStatsLogger.getOpStatsLogger("get_data");
        this.setStats = scopedStatsLogger.getOpStatsLogger("set_data");
        this.deleteStats = scopedStatsLogger.getOpStatsLogger("delete");
        this.getChildrenStats = scopedStatsLogger.getOpStatsLogger("get_children");
        this.existsStats = scopedStatsLogger.getOpStatsLogger("exists");
        this.multiStats = scopedStatsLogger.getOpStatsLogger("multi");
        this.getACLStats = scopedStatsLogger.getOpStatsLogger("get_acl");
        this.setACLStats = scopedStatsLogger.getOpStatsLogger("set_acl");
        this.syncStats = scopedStatsLogger.getOpStatsLogger("sync");
    }

    @Override
    public void close() throws InterruptedException {
        this.closed.set(true);
        this.connectExecutor.shutdown();
        this.retryExecutor.shutdown();
        this.closeZkHandle();
    }

    private void closeZkHandle() throws InterruptedException {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            super.close();
        } else {
            zkHandle.close();
        }
    }

    public void waitForConnection() throws KeeperException, InterruptedException {
        this.watcherManager.waitForConnection();
    }

    protected ZooKeeper createZooKeeper() throws IOException {
        return new ZooKeeper(this.connectString, this.sessionTimeoutMs, (Watcher)this.watcherManager, this.allowReadOnlyMode);
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
            this.onExpired();
        }
    }

    private void onExpired() {
        if (this.closed.get()) {
            return;
        }
        log.info("ZooKeeper session {} is expired from {}.", (Object)Long.toHexString(this.getSessionId()), (Object)this.connectString);
        try {
            this.connectExecutor.execute(this.clientCreator);
        }
        catch (RejectedExecutionException ree) {
            if (!this.closed.get()) {
                log.error("ZooKeeper reconnect task is rejected : ", (Throwable)ree);
            }
        }
        catch (Exception t) {
            log.error("Failed to submit zookeeper reconnect task due to runtime exception : ", (Throwable)t);
        }
    }

    public long getSessionId() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return super.getSessionId();
        }
        return zkHandle.getSessionId();
    }

    public byte[] getSessionPasswd() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return super.getSessionPasswd();
        }
        return zkHandle.getSessionPasswd();
    }

    public int getSessionTimeout() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return super.getSessionTimeout();
        }
        return zkHandle.getSessionTimeout();
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            super.addAuthInfo(scheme, auth);
            return;
        }
        zkHandle.addAuthInfo(scheme, auth);
    }

    private void backOffAndRetry(Runnable r, long nextRetryWaitTimeMs) {
        block2: {
            try {
                this.retryExecutor.schedule(r, nextRetryWaitTimeMs, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException ree) {
                if (this.closed.get()) break block2;
                log.error("ZooKeeper Operation {} is rejected : ", (Object)r, (Object)ree);
            }
        }
    }

    private boolean allowRetry(ZooWorker worker, int rc) {
        return worker.allowRetry(rc) && !this.closed.get();
    }

    public synchronized void register(Watcher watcher) {
        this.watcherManager.addChildWatcher(watcher);
    }

    public List<OpResult> multi(final Iterable<Op> ops) throws InterruptedException, KeeperException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<OpResult>>(){

            public String toString() {
                return "multi";
            }

            @Override
            public List<OpResult> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.multi(ops);
                }
                return zkHandle.multi(ops);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.multiStats);
    }

    public void multi(final Iterable<Op> ops, final AsyncCallback.MultiCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.createStats){
            final AsyncCallback.MultiCallback multiCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.multiCb = new AsyncCallback.MultiCallback(){

                    public void processResult(int rc, String path, Object ctx, List<OpResult> results) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, results);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.multi(ops, this.multiCb, this.worker);
                } else {
                    zkHandle.multi(ops, this.multiCb, (Object)this.worker);
                }
            }

            public String toString() {
                return "multi";
            }
        };
        proc.run();
    }

    @Deprecated
    public Transaction transaction() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return super.transaction();
        }
        return zkHandle.transaction();
    }

    public List<ACL> getACL(final String path, final Stat stat) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<ACL>>(){

            public String toString() {
                return String.format("getACL (%s, stat = %s)", path, stat);
            }

            @Override
            public List<ACL> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getACL(path, stat);
                }
                return zkHandle.getACL(path, stat);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getACLStats);
    }

    public void getACL(final String path, final Stat stat, final AsyncCallback.ACLCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getACLStats){
            final AsyncCallback.ACLCallback aclCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.aclCb = new AsyncCallback.ACLCallback(){

                    public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, acl, stat);
                        }
                    }
                };
            }

            public String toString() {
                return String.format("getACL (%s, stat = %s)", path, stat);
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getACL(path, stat, this.aclCb, this.worker);
                } else {
                    zkHandle.getACL(path, stat, this.aclCb, (Object)this.worker);
                }
            }
        };
        proc.run();
    }

    public Stat setACL(final String path, final List<ACL> acl, final int version) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Stat>(){

            public String toString() {
                return String.format("setACL (%s, acl = %s, version = %d)", path, acl, version);
            }

            @Override
            public Stat call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.setACL(path, acl, version);
                }
                return zkHandle.setACL(path, acl, version);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.setACLStats);
    }

    public void setACL(final String path, final List<ACL> acl, final int version, final AsyncCallback.StatCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.setACLStats){
            final AsyncCallback.StatCallback stCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.stCb = new AsyncCallback.StatCallback(){

                    public void processResult(int rc, String path, Object ctx, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, stat);
                        }
                    }
                };
            }

            public String toString() {
                return String.format("setACL (%s, acl = %s, version = %d)", path, acl, version);
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.setACL(path, acl, version, this.stCb, this.worker);
                } else {
                    zkHandle.setACL(path, acl, version, this.stCb, (Object)this.worker);
                }
            }
        };
        proc.run();
    }

    public void sync(final String path, final AsyncCallback.VoidCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.syncStats){
            final AsyncCallback.VoidCallback vCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.vCb = new AsyncCallback.VoidCallback(){

                    public void processResult(int rc, String path, Object ctx) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context);
                        }
                    }
                };
            }

            public String toString() {
                return String.format("sync (%s)", path);
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.sync(path, this.vCb, this.worker);
                } else {
                    zkHandle.sync(path, this.vCb, (Object)this.worker);
                }
            }
        };
        proc.run();
    }

    public ZooKeeper.States getState() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return PulsarZooKeeperClient.super.getState();
        }
        return zkHandle.getState();
    }

    public String toString() {
        ZooKeeper zkHandle = this.zk.get();
        if (null == zkHandle) {
            return PulsarZooKeeperClient.super.toString();
        }
        return zkHandle.toString();
    }

    public String create(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<String>(){

            @Override
            public String call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.create(path, data, acl, createMode);
                }
                return zkHandle.create(path, data, acl, createMode);
            }

            public String toString() {
                return String.format("create (%s, acl = %s, mode = %s)", path, acl, createMode);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.createStats);
    }

    public void create(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.createStats){
            final AsyncCallback.StringCallback createCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.createCb = new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, name);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.create(path, data, acl, createMode, this.createCb, this.worker);
                } else {
                    zkHandle.create(path, data, acl, createMode, this.createCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("create (%s, acl = %s, mode = %s)", path, acl, createMode);
            }
        };
        proc.run();
    }

    public void delete(final String path, final int version) throws KeeperException, InterruptedException {
        ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Void>(){

            @Override
            public Void call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.delete(path, version);
                } else {
                    zkHandle.delete(path, version);
                }
                return null;
            }

            public String toString() {
                return String.format("delete (%s, version = %d)", path, version);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.deleteStats);
    }

    public void delete(final String path, final int version, final AsyncCallback.VoidCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.deleteStats){
            final AsyncCallback.VoidCallback deleteCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.deleteCb = new AsyncCallback.VoidCallback(){

                    public void processResult(int rc, String path, Object ctx) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.delete(path, version, this.deleteCb, this.worker);
                } else {
                    zkHandle.delete(path, version, this.deleteCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("delete (%s, version = %d)", path, version);
            }
        };
        proc.run();
    }

    public Stat exists(final String path, final Watcher watcher) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Stat>(){

            @Override
            public Stat call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.exists(path, watcher);
                }
                return zkHandle.exists(path, watcher);
            }

            public String toString() {
                return String.format("exists (%s, watcher = %s)", path, watcher);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.existsStats);
    }

    public Stat exists(final String path, final boolean watch) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Stat>(){

            @Override
            public Stat call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.exists(path, watch);
                }
                return zkHandle.exists(path, watch);
            }

            public String toString() {
                return String.format("exists (%s, watcher = %s)", path, watch);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.existsStats);
    }

    public void exists(final String path, final Watcher watcher, final AsyncCallback.StatCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.existsStats){
            final AsyncCallback.StatCallback stCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.stCb = new AsyncCallback.StatCallback(){

                    public void processResult(int rc, String path, Object ctx, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.exists(path, watcher, this.stCb, this.worker);
                } else {
                    zkHandle.exists(path, watcher, this.stCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("exists (%s, watcher = %s)", path, watcher);
            }
        };
        proc.run();
    }

    public void exists(final String path, final boolean watch, final AsyncCallback.StatCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.existsStats){
            final AsyncCallback.StatCallback stCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.stCb = new AsyncCallback.StatCallback(){

                    public void processResult(int rc, String path, Object ctx, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.exists(path, watch, this.stCb, this.worker);
                } else {
                    zkHandle.exists(path, watch, this.stCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("exists (%s, watcher = %s)", path, watch);
            }
        };
        proc.run();
    }

    public byte[] getData(final String path, final Watcher watcher, final Stat stat) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<byte[]>(){

            @Override
            public byte[] call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getData(path, watcher, stat);
                }
                return zkHandle.getData(path, watcher, stat);
            }

            public String toString() {
                return String.format("getData (%s, watcher = %s)", path, watcher);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getStats);
    }

    public byte[] getData(final String path, final boolean watch, final Stat stat) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<byte[]>(){

            @Override
            public byte[] call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getData(path, watch, stat);
                }
                return zkHandle.getData(path, watch, stat);
            }

            public String toString() {
                return String.format("getData (%s, watcher = %s)", path, watch);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getStats);
    }

    public void getData(final String path, final Watcher watcher, final AsyncCallback.DataCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getStats){
            final AsyncCallback.DataCallback dataCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.dataCb = new AsyncCallback.DataCallback(){

                    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, data, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getData(path, watcher, this.dataCb, this.worker);
                } else {
                    zkHandle.getData(path, watcher, this.dataCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getData (%s, watcher = %s)", path, watcher);
            }
        };
        proc.run();
    }

    public void getData(final String path, final boolean watch, final AsyncCallback.DataCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getStats){
            final AsyncCallback.DataCallback dataCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.dataCb = new AsyncCallback.DataCallback(){

                    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, data, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getData(path, watch, this.dataCb, this.worker);
                } else {
                    zkHandle.getData(path, watch, this.dataCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getData (%s, watcher = %s)", path, watch);
            }
        };
        proc.run();
    }

    public Stat setData(final String path, final byte[] data, final int version) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Stat>(){

            @Override
            public Stat call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.setData(path, data, version);
                }
                return zkHandle.setData(path, data, version);
            }

            public String toString() {
                return String.format("setData (%s, version = %d)", path, version);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.setStats);
    }

    public void setData(final String path, final byte[] data, final int version, final AsyncCallback.StatCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.setStats){
            final AsyncCallback.StatCallback stCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.stCb = new AsyncCallback.StatCallback(){

                    public void processResult(int rc, String path, Object ctx, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.setData(path, data, version, this.stCb, this.worker);
                } else {
                    zkHandle.setData(path, data, version, this.stCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("setData (%s, version = %d)", path, version);
            }
        };
        proc.run();
    }

    public void addWatch(final String basePath, final Watcher watcher, final AddWatchMode mode) throws KeeperException, InterruptedException {
        ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<Void>(){

            @Override
            public Void call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.addWatch(basePath, watcher, mode);
                } else {
                    zkHandle.addWatch(basePath, watcher, mode);
                }
                return null;
            }

            public String toString() {
                return String.format("addWatch (%s, mode = %s)", basePath, mode);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.setStats);
    }

    public void addWatch(final String basePath, final Watcher watcher, final AddWatchMode mode, final AsyncCallback.VoidCallback cb, final Object ctx) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.setStats){
            final AsyncCallback.VoidCallback vCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.vCb = new AsyncCallback.VoidCallback(){

                    public void processResult(int rc, String path, Object ctx) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            vCb.processResult(rc, basePath, ctx);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.addWatch(basePath, watcher, mode, cb, ctx);
                } else {
                    zkHandle.addWatch(basePath, watcher, mode, cb, ctx);
                }
            }

            public String toString() {
                return String.format("setData (%s, mode = %s)", basePath, mode.name());
            }
        };
        proc.run();
    }

    public List<String> getChildren(final String path, final Watcher watcher, final Stat stat) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<String>>(){

            @Override
            public List<String> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getChildren(path, watcher, stat);
                }
                return zkHandle.getChildren(path, watcher, stat);
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watcher);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats);
    }

    public List<String> getChildren(final String path, final boolean watch, final Stat stat) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<String>>(){

            @Override
            public List<String> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getChildren(path, watch, stat);
                }
                return zkHandle.getChildren(path, watch, stat);
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watch);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats);
    }

    public void getChildren(final String path, final Watcher watcher, final AsyncCallback.Children2Callback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats){
            final AsyncCallback.Children2Callback childCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.childCb = new AsyncCallback.Children2Callback(){

                    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, children, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getChildren(path, watcher, this.childCb, this.worker);
                } else {
                    zkHandle.getChildren(path, watcher, this.childCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watcher);
            }
        };
        proc.run();
    }

    public void getChildren(final String path, final boolean watch, final AsyncCallback.Children2Callback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats){
            final AsyncCallback.Children2Callback childCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.childCb = new AsyncCallback.Children2Callback(){

                    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, children, stat);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getChildren(path, watch, this.childCb, this.worker);
                } else {
                    zkHandle.getChildren(path, watch, this.childCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watch);
            }
        };
        proc.run();
    }

    public List<String> getChildren(final String path, final Watcher watcher) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<String>>(){

            @Override
            public List<String> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getChildren(path, watcher);
                }
                return zkHandle.getChildren(path, watcher);
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watcher);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats);
    }

    public List<String> getChildren(final String path, final boolean watch) throws KeeperException, InterruptedException {
        return ZooWorker.syncCallWithRetries(this, new ZooWorker.ZooCallable<List<String>>(){

            @Override
            public List<String> call() throws KeeperException, InterruptedException {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    return PulsarZooKeeperClient.super.getChildren(path, watch);
                }
                return zkHandle.getChildren(path, watch);
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watch);
            }
        }, this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats);
    }

    public void getChildren(final String path, final Watcher watcher, final AsyncCallback.ChildrenCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats){
            final AsyncCallback.ChildrenCallback childCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.childCb = new AsyncCallback.ChildrenCallback(){

                    public void processResult(int rc, String path, Object ctx, List<String> children) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, children);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getChildren(path, watcher, this.childCb, this.worker);
                } else {
                    zkHandle.getChildren(path, watcher, this.childCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watcher);
            }
        };
        proc.run();
    }

    public void getChildren(final String path, final boolean watch, final AsyncCallback.ChildrenCallback cb, final Object context) {
        ZkRetryRunnable proc = new ZkRetryRunnable(this.operationRetryPolicy, this.rateLimiter, this.getChildrenStats){
            final AsyncCallback.ChildrenCallback childCb;
            {
                super(retryPolicy, rateLimiter, statsLogger);
                this.childCb = new AsyncCallback.ChildrenCallback(){

                    public void processResult(int rc, String path, Object ctx, List<String> children) {
                        ZooWorker worker = (ZooWorker)ctx;
                        if (PulsarZooKeeperClient.this.allowRetry(worker, rc)) {
                            PulsarZooKeeperClient.this.backOffAndRetry(that, worker.nextRetryWaitTime());
                        } else {
                            cb.processResult(rc, path, context, children);
                        }
                    }
                };
            }

            @Override
            void zkRun() {
                ZooKeeper zkHandle = PulsarZooKeeperClient.this.zk.get();
                if (null == zkHandle) {
                    PulsarZooKeeperClient.super.getChildren(path, watch, this.childCb, this.worker);
                } else {
                    zkHandle.getChildren(path, watch, this.childCb, (Object)this.worker);
                }
            }

            public String toString() {
                return String.format("getChildren (%s, watcher = %s)", path, watch);
            }
        };
        proc.run();
    }

    public static class Builder {
        String connectString = null;
        int sessionTimeoutMs = 10000;
        Set<Watcher> watchers = null;
        RetryPolicy connectRetryPolicy = null;
        RetryPolicy operationRetryPolicy = null;
        StatsLogger statsLogger = NullStatsLogger.INSTANCE;
        int retryExecThreadCount = 1;
        double requestRateLimit = 0.0;
        boolean allowReadOnlyMode = false;

        private Builder() {
        }

        public Builder connectString(String connectString) {
            this.connectString = connectString;
            return this;
        }

        public Builder sessionTimeoutMs(int sessionTimeoutMs) {
            this.sessionTimeoutMs = sessionTimeoutMs;
            return this;
        }

        public Builder watchers(Set<Watcher> watchers) {
            this.watchers = watchers;
            return this;
        }

        public Builder connectRetryPolicy(RetryPolicy retryPolicy) {
            this.connectRetryPolicy = retryPolicy;
            return this;
        }

        public Builder operationRetryPolicy(RetryPolicy retryPolicy) {
            this.operationRetryPolicy = retryPolicy;
            return this;
        }

        public Builder statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public Builder requestRateLimit(double requestRateLimit) {
            this.requestRateLimit = requestRateLimit;
            return this;
        }

        public Builder retryThreadCount(int numThreads) {
            this.retryExecThreadCount = numThreads;
            return this;
        }

        public Builder allowReadOnlyMode(boolean allowReadOnlyMode) {
            this.allowReadOnlyMode = allowReadOnlyMode;
            return this;
        }

        public PulsarZooKeeperClient build() throws IOException, KeeperException, InterruptedException {
            Objects.requireNonNull(this.connectString);
            Preconditions.checkArgument((this.sessionTimeoutMs > 0 ? 1 : 0) != 0);
            Objects.requireNonNull(this.statsLogger);
            Preconditions.checkArgument((this.retryExecThreadCount > 0 ? 1 : 0) != 0);
            if (null == this.connectRetryPolicy) {
                this.connectRetryPolicy = new BoundExponentialBackoffRetryPolicy(0L, 0L, Integer.MAX_VALUE);
            }
            if (null == this.operationRetryPolicy) {
                this.operationRetryPolicy = new BoundExponentialBackoffRetryPolicy((long)this.sessionTimeoutMs, (long)this.sessionTimeoutMs, 0);
            }
            StatsLogger watcherStatsLogger = this.statsLogger.scope("watcher");
            ZooKeeperWatcherBase watcherManager = null == this.watchers ? new ZooKeeperWatcherBase(this.sessionTimeoutMs, this.allowReadOnlyMode, watcherStatsLogger) : new ZooKeeperWatcherBase(this.sessionTimeoutMs, this.allowReadOnlyMode, this.watchers, watcherStatsLogger);
            PulsarZooKeeperClient client = new PulsarZooKeeperClient(this.connectString, this.sessionTimeoutMs, watcherManager, this.connectRetryPolicy, this.operationRetryPolicy, this.statsLogger, this.retryExecThreadCount, this.requestRateLimit, this.allowReadOnlyMode);
            try {
                watcherManager.waitForConnection();
            }
            catch (KeeperException ke) {
                client.close();
                throw ke;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                client.close();
                throw ie;
            }
            return client;
        }
    }

    static final class ZooWorker {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ZooWorker.class);
        int attempts = 0;
        long startTimeNanos;
        long elapsedTimeMs = 0L;
        final RetryPolicy retryPolicy;
        final OpStatsLogger statsLogger;

        ZooWorker(RetryPolicy retryPolicy, OpStatsLogger statsLogger) {
            this.retryPolicy = retryPolicy;
            this.statsLogger = statsLogger;
            this.startTimeNanos = MathUtils.nowInNano();
        }

        public boolean allowRetry(int rc) {
            this.elapsedTimeMs = MathUtils.elapsedMSec((long)this.startTimeNanos);
            if (!ZooWorker.isRecoverableException(rc)) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    this.statsLogger.registerSuccessfulEvent(MathUtils.elapsedMicroSec((long)this.startTimeNanos), TimeUnit.MICROSECONDS);
                } else {
                    this.statsLogger.registerFailedEvent(MathUtils.elapsedMicroSec((long)this.startTimeNanos), TimeUnit.MICROSECONDS);
                }
                return false;
            }
            ++this.attempts;
            return this.retryPolicy.allowRetry(this.attempts, this.elapsedTimeMs);
        }

        public long nextRetryWaitTime() {
            return this.retryPolicy.nextRetryWaitTime(this.attempts, this.elapsedTimeMs);
        }

        public static boolean isRecoverableException(int rc) {
            return KeeperException.Code.CONNECTIONLOSS.intValue() == rc || KeeperException.Code.OPERATIONTIMEOUT.intValue() == rc || KeeperException.Code.SESSIONMOVED.intValue() == rc || KeeperException.Code.SESSIONEXPIRED.intValue() == rc;
        }

        public static boolean isRecoverableException(KeeperException exception) {
            return ZooWorker.isRecoverableException(exception.code().intValue());
        }

        public static <T> T syncCallWithRetries(PulsarZooKeeperClient client, ZooCallable<T> proc, RetryPolicy retryPolicy, RateLimiter rateLimiter, OpStatsLogger statsLogger) throws KeeperException, InterruptedException {
            T result = null;
            boolean isDone = false;
            int attempts = 0;
            long startTimeNanos = MathUtils.nowInNano();
            while (!isDone) {
                try {
                    if (null != client) {
                        client.waitForConnection();
                    }
                    log.debug("Execute {} at {} retry attempt.", proc, (Object)attempts);
                    if (null != rateLimiter) {
                        rateLimiter.acquire();
                    }
                    result = proc.call();
                    isDone = true;
                    statsLogger.registerSuccessfulEvent(MathUtils.elapsedMicroSec((long)startTimeNanos), TimeUnit.MICROSECONDS);
                }
                catch (KeeperException e) {
                    boolean rethrow = true;
                    long elapsedTime = MathUtils.elapsedMSec((long)startTimeNanos);
                    if ((null != client && ZooWorker.isRecoverableException(e) || null == client) && retryPolicy.allowRetry(++attempts, elapsedTime)) {
                        rethrow = false;
                    }
                    if (rethrow) {
                        statsLogger.registerFailedEvent(MathUtils.elapsedMicroSec((long)startTimeNanos), TimeUnit.MICROSECONDS);
                        log.debug("Stopped executing {} after {} attempts.", proc, (Object)attempts);
                        throw e;
                    }
                    TimeUnit.MILLISECONDS.sleep(retryPolicy.nextRetryWaitTime(attempts, elapsedTime));
                }
            }
            return result;
        }

        static interface ZooCallable<T> {
            public T call() throws InterruptedException, KeeperException;
        }
    }

    static abstract class ZkRetryRunnable
    implements Runnable {
        final ZooWorker worker;
        final RateLimiter rateLimiter;
        final Runnable that;

        ZkRetryRunnable(RetryPolicy retryPolicy, RateLimiter rateLimiter, OpStatsLogger statsLogger) {
            this.worker = new ZooWorker(retryPolicy, statsLogger);
            this.rateLimiter = rateLimiter;
            this.that = this;
        }

        @Override
        public void run() {
            if (null != this.rateLimiter) {
                this.rateLimiter.acquire();
            }
            this.zkRun();
        }

        abstract void zkRun();
    }
}

