/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class TypeParameterUtils {
    private TypeParameterUtils() {
    }

    public static Type[] getTypeParameters(Class<?> desiredType, Type type) {
        if (type instanceof Class) {
            Class rawClass = (Class)type;
            if (desiredType.equals(type)) {
                return null;
            }
            for (Type iface : rawClass.getGenericInterfaces()) {
                Type[] collectionType = TypeParameterUtils.getTypeParameters(desiredType, iface);
                if (collectionType == null) continue;
                return collectionType;
            }
            return TypeParameterUtils.getTypeParameters(desiredType, rawClass.getGenericSuperclass());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (desiredType.equals(rawType)) {
                return parameterizedType.getActualTypeArguments();
            }
            Type[] collectionTypes = TypeParameterUtils.getTypeParameters(desiredType, rawType);
            if (collectionTypes != null) {
                for (int i = 0; i < collectionTypes.length; ++i) {
                    if (!(collectionTypes[i] instanceof TypeVariable)) continue;
                    TypeVariable typeVariable = (TypeVariable)collectionTypes[i];
                    TypeVariable<?>[] rawTypeParams = ((GenericDeclaration)((Object)rawType)).getTypeParameters();
                    for (int j = 0; j < rawTypeParams.length; ++j) {
                        if (!typeVariable.getName().equals(rawTypeParams[j].getName())) continue;
                        collectionTypes[i] = parameterizedType.getActualTypeArguments()[j];
                    }
                }
            }
            return collectionTypes;
        }
        return null;
    }
}

