/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

public class JsonCodec<T> {
    static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS}).disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS}).disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS}).disable(new MapperFeature[]{MapperFeature.INFER_PROPERTY_MUTATORS}).disable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS}).registerModule((Module)new Jdk8Module());
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    private JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromJson(String json) throws JsonProcessingException {
        return (T)this.mapper.readerFor(this.javaType).readValue(json);
    }
}

