/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.javax.annotation.Nonnull;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.inject.InjectionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSqlSchemaInfoProvider
implements SchemaInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSqlSchemaInfoProvider.class);
    private final TopicName topicName;
    private final PulsarAdmin pulsarAdmin;
    private final LoadingCache<BytesSchemaVersion, CompletableFuture<SchemaInfo>> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BytesSchemaVersion, CompletableFuture<SchemaInfo>>(){

        @Nonnull
        public CompletableFuture<SchemaInfo> load(@Nonnull BytesSchemaVersion schemaVersion) {
            return PulsarSqlSchemaInfoProvider.this.loadSchema(schemaVersion);
        }
    });

    public PulsarSqlSchemaInfoProvider(TopicName topicName, PulsarAdmin pulsarAdmin) {
        this.topicName = topicName;
        this.pulsarAdmin = pulsarAdmin;
    }

    public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
        try {
            if (null == schemaVersion) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)this.cache.get((Object)BytesSchemaVersion.of((byte[])schemaVersion));
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic %s schema version %s", new Object[]{this.topicName.toString(), new String(schemaVersion, StandardCharsets.UTF_8), e});
            return FutureUtil.failedFuture((Throwable)e.getCause());
        }
    }

    public CompletableFuture<SchemaInfo> getLatestSchema() {
        return this.pulsarAdmin.schemas().getSchemaInfoAsync(this.topicName.toString());
    }

    public String getTopicName() {
        return this.topicName.getLocalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<SchemaInfo> loadSchema(BytesSchemaVersion bytesSchemaVersion) {
        ClassLoader originalContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(InjectionManagerFactory.class.getClassLoader());
            long version = ByteBuffer.wrap(bytesSchemaVersion.get()).getLong();
            CompletableFuture completableFuture = this.pulsarAdmin.schemas().getSchemaInfoAsync(this.topicName.toString(), version);
            return completableFuture;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextLoader);
        }
    }

    public static SchemaInfo defaultSchema() {
        return Schema.BYTES.getSchemaInfo();
    }
}

