/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.metrics.Count;
import java.util.Objects;

public class LongCount
implements Count<LongCount> {
    private final long total;

    @JsonCreator
    public LongCount(long total) {
        this.total = total;
    }

    @JsonProperty(value="total")
    public long getTotal() {
        return this.total;
    }

    public LongCount mergeWith(LongCount other) {
        return new LongCount(this.total + other.getTotal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongCount count = (LongCount)o;
        return this.total == count.total;
    }

    public int hashCode() {
        return Objects.hash(this.total);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("total", this.total).toString();
    }
}

