/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SubscriptExpression;
import java.util.ArrayDeque;

public class UnwrapRowSubscript
extends ExpressionRewriteRuleSet {
    public UnwrapRowSubscript() {
        super((expression, context) -> ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(), (Expression)expression));
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private Rewriter() {
        }

        public Expression rewriteSubscriptExpression(SubscriptExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            int index;
            Cast cast;
            Expression base = treeRewriter.rewrite(node.getBase(), (Object)context);
            ArrayDeque<Coercion> coercions = new ArrayDeque<Coercion>();
            while (base instanceof Cast && (cast = (Cast)base).getType() instanceof RowDataType) {
                index = (int)((LongLiteral)node.getIndex()).getValue();
                RowDataType rowType = (RowDataType)cast.getType();
                DataType type = ((RowDataType.Field)rowType.getFields().get(index - 1)).getType();
                if (!(type instanceof GenericDataType) || !((GenericDataType)type).getName().getValue().equalsIgnoreCase("unknown")) {
                    coercions.push(new Coercion(type, cast.isTypeOnly(), cast.isSafe()));
                }
                base = cast.getExpression();
            }
            if (base instanceof Row) {
                Row row = (Row)base;
                index = (int)((LongLiteral)node.getIndex()).getValue();
                Expression result = (Expression)row.getItems().get(index - 1);
                while (!coercions.isEmpty()) {
                    Coercion coercion = (Coercion)coercions.pop();
                    result = new Cast(result, coercion.getType(), coercion.isSafe(), coercion.isTypeOnly());
                }
                return result;
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }
    }

    private static class Coercion {
        private final DataType type;
        private final boolean typeOnly;
        private final boolean safe;

        public Coercion(DataType type, boolean typeOnly, boolean safe) {
            this.type = type;
            this.typeOnly = typeOnly;
            this.safe = safe;
        }

        public DataType getType() {
            return this.type;
        }

        public boolean isTypeOnly() {
            return this.typeOnly;
        }

        public boolean isSafe() {
            return this.safe;
        }
    }
}

