/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Set;

public class ReplaceRedundantJoinWithSource
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        if (QueryCardinalityUtil.isAtMost(node.getLeft(), context.getLookup(), 0L) || QueryCardinalityUtil.isAtMost(node.getRight(), context.getLookup(), 0L)) {
            return Rule.Result.empty();
        }
        boolean leftSourceScalarWithNoOutputs = node.getLeft().getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(node.getLeft(), context.getLookup());
        boolean rightSourceScalarWithNoOutputs = node.getRight().getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(node.getRight(), context.getLookup());
        switch (node.getType()) {
            case INNER: {
                List<Symbol> sourceOutputs;
                PlanNode source;
                if (leftSourceScalarWithNoOutputs) {
                    source = node.getRight();
                    sourceOutputs = node.getRightOutputSymbols();
                } else if (rightSourceScalarWithNoOutputs) {
                    source = node.getLeft();
                    sourceOutputs = node.getLeftOutputSymbols();
                } else {
                    return Rule.Result.empty();
                }
                if (node.getFilter().isPresent()) {
                    source = new FilterNode(context.getIdAllocator().getNextId(), source, node.getFilter().get());
                }
                return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), source, (Set<Symbol>)ImmutableSet.copyOf(sourceOutputs)).orElse(source));
            }
            case LEFT: {
                if (!rightSourceScalarWithNoOutputs) break;
                return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), node.getLeft(), (Set<Symbol>)ImmutableSet.copyOf(node.getLeftOutputSymbols())).orElse(node.getLeft()));
            }
            case RIGHT: {
                if (!leftSourceScalarWithNoOutputs) break;
                return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), node.getRight(), (Set<Symbol>)ImmutableSet.copyOf(node.getRightOutputSymbols())).orElse(node.getRight()));
            }
            case FULL: {
                if (leftSourceScalarWithNoOutputs && QueryCardinalityUtil.isAtLeastScalar(node.getRight(), context.getLookup())) {
                    return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), node.getRight(), (Set<Symbol>)ImmutableSet.copyOf(node.getRightOutputSymbols())).orElse(node.getRight()));
                }
                if (!rightSourceScalarWithNoOutputs || !QueryCardinalityUtil.isAtLeastScalar(node.getLeft(), context.getLookup())) break;
                return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), node.getLeft(), (Set<Symbol>)ImmutableSet.copyOf(node.getLeftOutputSymbols())).orElse(node.getLeft()));
            }
        }
        return Rule.Result.empty();
    }
}

