/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Set;

public class PruneExceptSourceColumns
implements Rule<ExceptNode> {
    @Override
    public Pattern<ExceptNode> getPattern() {
        return Patterns.except();
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        Set[] referencedInputs = new Set[node.getSources().size()];
        for (int i = 0; i < node.getSources().size(); ++i) {
            referencedInputs[i] = ImmutableSet.copyOf(node.sourceOutputLayout(i));
        }
        return Util.restrictChildOutputs(context.getIdAllocator(), node, referencedInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

