/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneApplyColumns
extends ProjectOffPushDownRule<ApplyNode> {
    public PruneApplyColumns() {
        super(Patterns.applyNode());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, ApplyNode applyNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        if (Sets.intersection(applyNode.getSubqueryAssignments().getSymbols(), referencedOutputs).isEmpty()) {
            return Optional.of(applyNode.getInput());
        }
        ImmutableSet.Builder requiredAssignmentsSymbols = ImmutableSet.builder();
        Assignments.Builder newSubqueryAssignments = Assignments.builder();
        for (Map.Entry<Symbol, Expression> entry : applyNode.getSubqueryAssignments().entrySet()) {
            if (!referencedOutputs.contains(entry.getKey())) continue;
            requiredAssignmentsSymbols.addAll(SymbolsExtractor.extractUnique(entry.getValue()));
            newSubqueryAssignments.put(entry);
        }
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), applyNode.getSubquery(), (Set<Symbol>)requiredAssignmentsSymbols.build());
        ImmutableSet requiredInputSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(applyNode.getCorrelation()).addAll((Iterable)requiredAssignmentsSymbols.build()).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), applyNode.getInput(), (Set<Symbol>)requiredInputSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent() || newSubqueryAssignments.build().size() < applyNode.getSubqueryAssignments().size();
        if (pruned) {
            return Optional.of(new ApplyNode(applyNode.getId(), newInput.orElse(applyNode.getInput()), newSubquery.orElse(applyNode.getSubquery()), newSubqueryAssignments.build(), applyNode.getCorrelation(), applyNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

