/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.joins.JoinGraph;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;

public class EliminateCrossJoins
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;

    public EliminateCrossJoins(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        this.metadata = metadata;
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        FeaturesConfig.JoinReorderingStrategy joinReorderingStrategy = SystemSessionProperties.getJoinReorderingStrategy(session);
        return joinReorderingStrategy == FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS || joinReorderingStrategy == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        JoinGraph joinGraph = JoinGraph.buildFrom(this.metadata, node, context.getLookup(), context.getIdAllocator(), context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes());
        if (joinGraph.size() < 3 || !joinGraph.isContainsCrossJoin()) {
            return Rule.Result.empty();
        }
        List<Integer> joinOrder = EliminateCrossJoins.getJoinOrder(joinGraph);
        if (EliminateCrossJoins.isOriginalOrder(joinOrder)) {
            return Rule.Result.empty();
        }
        PlanNode replacement = EliminateCrossJoins.buildJoinTree(node.getOutputSymbols(), joinGraph, joinOrder, context.getIdAllocator());
        return Rule.Result.ofPlanNode(replacement);
    }

    public static boolean isOriginalOrder(List<Integer> joinOrder) {
        for (int i = 0; i < joinOrder.size(); ++i) {
            if (joinOrder.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> getJoinOrder(JoinGraph graph) {
        ImmutableList.Builder joinOrder = ImmutableList.builder();
        HashMap<PlanNodeId, Integer> priorities = new HashMap<PlanNodeId, Integer>();
        for (int i = 0; i < graph.size(); ++i) {
            priorities.put(graph.getNode(i).getId(), i);
        }
        PriorityQueue<PlanNode> nodesToVisit = new PriorityQueue<PlanNode>(graph.size(), Comparator.comparing(node -> (Integer)priorities.get(node.getId())));
        HashSet<PlanNode> visited = new HashSet<PlanNode>();
        nodesToVisit.add(graph.getNode(0));
        while (!nodesToVisit.isEmpty()) {
            PlanNode node2 = nodesToVisit.poll();
            if (!visited.contains(node2)) {
                visited.add(node2);
                joinOrder.add((Object)node2);
                for (JoinGraph.Edge edge : graph.getEdges(node2)) {
                    nodesToVisit.add(edge.getTargetNode());
                }
            }
            if (!nodesToVisit.isEmpty() || visited.size() >= graph.size()) continue;
            Optional<PlanNode> firstNotVisitedNode = graph.getNodes().stream().filter(graphNode -> !visited.contains(graphNode)).findFirst();
            firstNotVisitedNode.ifPresent(nodesToVisit::add);
        }
        Preconditions.checkState((visited.size() == graph.size() ? 1 : 0) != 0);
        return (List)joinOrder.build().stream().map(node -> (Integer)priorities.get(node.getId())).collect(ImmutableList.toImmutableList());
    }

    public static PlanNode buildJoinTree(List<Symbol> expectedOutputSymbols, JoinGraph graph, List<Integer> joinOrder, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(expectedOutputSymbols, "expectedOutputSymbols is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(graph, "graph is null");
        joinOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(joinOrder, "joinOrder is null"));
        Preconditions.checkArgument((joinOrder.size() >= 2 ? 1 : 0) != 0);
        PlanNode result = graph.getNode((Integer)joinOrder.get(0));
        HashSet<PlanNodeId> alreadyJoinedNodes = new HashSet<PlanNodeId>();
        alreadyJoinedNodes.add(result.getId());
        for (int i = 1; i < joinOrder.size(); ++i) {
            PlanNode rightNode = graph.getNode((Integer)joinOrder.get(i));
            alreadyJoinedNodes.add(rightNode.getId());
            ImmutableList.Builder criteria = ImmutableList.builder();
            for (JoinGraph.Edge edge : graph.getEdges(rightNode)) {
                PlanNode targetNode = edge.getTargetNode();
                if (!alreadyJoinedNodes.contains(targetNode.getId())) continue;
                criteria.add((Object)new JoinNode.EquiJoinClause(edge.getTargetSymbol(), edge.getSourceSymbol()));
            }
            result = new JoinNode(idAllocator.getNextId(), JoinNode.Type.INNER, result, rightNode, (List<JoinNode.EquiJoinClause>)criteria.build(), result.getOutputSymbols(), rightNode.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        }
        List<Expression> filters = graph.getFilters();
        for (Expression filter : filters) {
            result = new FilterNode(idAllocator.getNextId(), result, filter);
        }
        return Util.restrictOutputs(idAllocator, result, (Set<Symbol>)ImmutableSet.copyOf(expectedOutputSymbols)).orElse(result);
    }
}

