/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.SortItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderingScheme {
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;

    @JsonCreator
    public OrderingScheme(@JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings) {
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(orderings, "orderings is null");
        Preconditions.checkArgument((!orderBy.isEmpty() ? 1 : 0) != 0, (Object)"orderBy is empty");
        Preconditions.checkArgument((boolean)orderings.keySet().equals(ImmutableSet.copyOf(orderBy)), (Object)"orderBy keys and orderings don't match");
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
    }

    @JsonProperty
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    public List<SortOrder> getOrderingList() {
        return (List)this.orderBy.stream().map(this.orderings::get).collect(ImmutableList.toImmutableList());
    }

    public SortOrder getOrdering(Symbol symbol) {
        Preconditions.checkArgument((boolean)this.orderings.containsKey(symbol), (String)"No ordering for symbol: %s", (Object)symbol);
        return this.orderings.get(symbol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderingScheme that = (OrderingScheme)o;
        return Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.orderings, that.orderings);
    }

    public int hashCode() {
        return Objects.hash(this.orderBy, this.orderings);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orderBy", this.orderBy).add("orderings", this.orderings).toString();
    }

    public static OrderingScheme fromOrderBy(OrderBy orderBy) {
        List orderBySymbols = (List)orderBy.getSortItems().stream().map(io.trino.sql.tree.SortItem::getSortKey).map(Symbol::from).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder symbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orders = new HashMap<Symbol, SortOrder>();
        for (int i = 0; i < orderBySymbols.size(); ++i) {
            Symbol symbol = (Symbol)orderBySymbols.get(i);
            if (orders.containsKey(symbol)) continue;
            symbols.add((Object)symbol);
            orders.put(symbol, OrderingScheme.sortItemToSortOrder((io.trino.sql.tree.SortItem)orderBy.getSortItems().get(i)));
        }
        return new OrderingScheme((List<Symbol>)symbols.build(), orders);
    }

    public static SortOrder sortItemToSortOrder(io.trino.sql.tree.SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }

    public List<SortItem> toSortItems() {
        return (List)this.getOrderBy().stream().map(symbol -> new SortItem(symbol.getName(), SortOrder.valueOf((String)this.getOrdering((Symbol)symbol).name()))).collect(ImmutableList.toImmutableList());
    }

    public List<LocalProperty<Symbol>> toLocalProperties() {
        return (List)this.getOrderBy().stream().map(symbol -> new SortingProperty(symbol, this.getOrdering((Symbol)symbol))).collect(ImmutableList.toImmutableList());
    }
}

