/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import io.trino.type.LikePatternType;
import java.util.Map;
import java.util.Objects;

public final class DesugarLikeRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata, Session session) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes, metadata, session), (Expression)expression);
    }

    private DesugarLikeRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider typeProvider) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, typeProvider, expression);
        return DesugarLikeRewriter.rewrite(expression, expressionTypes, metadata, session);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;
        private final Metadata metadata;
        private final Session session;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata, Session session) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
            this.metadata = metadata;
            this.session = session;
        }

        public FunctionCall rewriteLikePredicate(LikePredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            LikePredicate rewritten = (LikePredicate)treeRewriter.defaultRewrite((Expression)node, (Object)context);
            FunctionCall patternCall = rewritten.getEscape().isPresent() ? FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$like_pattern")).addArgument(this.getType(node.getPattern()), rewritten.getPattern()).addArgument(this.getType((Expression)node.getEscape().get()), (Expression)rewritten.getEscape().get()).build() : FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$like_pattern")).addArgument(this.getType(node.getPattern()), rewritten.getPattern()).build();
            return FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"LIKE")).addArgument(this.getType(node.getValue()), rewritten.getValue()).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

