/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;

public final class OAuthWebUiCookie {
    public static final String OAUTH2_COOKIE = "__Secure-Trino-OAuth2-Token";

    private OAuthWebUiCookie() {
    }

    public static NewCookie create(String accessToken, Instant tokenExpiration) {
        return new NewCookie(OAUTH2_COOKIE, accessToken, "/ui/", null, 1, null, -1, Date.from(tokenExpiration), true, true);
    }

    public static Optional<String> read(Cookie cookie) {
        return Optional.ofNullable(cookie).map(Cookie::getValue).filter(Predicate.not(String::isBlank));
    }

    public static NewCookie delete() {
        return new NewCookie(OAUTH2_COOKIE, "delete", "/ui/", null, 1, null, 0, null, true, true);
    }
}

