/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;

@Description(value="Formats the given time by the given format")
@ScalarFunction(value="format_datetime")
public class FormatDateTime {
    private FormatDateTime() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        timestamp = DateTimes.scaleEpochMicrosToMillis(DateTimes.round(timestamp, 3));
        if (FormatDateTime.datetimeFormatSpecifiesZone(formatString)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "format_datetime for TIMESTAMP type, cannot use 'Z' nor 'z' in format, as this type does not contain TZ information");
        }
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        try {
            return Slices.utf8Slice((String)DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)chronology).withLocale(session.getLocale()).print(timestamp));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice formatDatetime(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return FormatDateTime.format(session, timestamp.getEpochMicros(), formatString);
    }

    private static boolean datetimeFormatSpecifiesZone(Slice formatString) {
        boolean quoted = false;
        for (char c : formatString.toStringUtf8().toCharArray()) {
            if (quoted) {
                if (c != '\'') continue;
                quoted = false;
                continue;
            }
            switch (c) {
                case 'Z': 
                case 'z': {
                    return true;
                }
                case '\'': {
                    quoted = true;
                }
            }
        }
        return false;
    }
}

