/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.ScaledDurationField;

public final class QuarterOfYearDateTimeField
extends DateTimeFieldType {
    private static final long serialVersionUID = -5677872459807379123L;
    private static final DurationFieldType QUARTER_OF_YEAR_DURATION_FIELD_TYPE = new QuarterOfYearDurationFieldType();
    public static final DateTimeFieldType QUARTER_OF_YEAR = new QuarterOfYearDateTimeField();

    private QuarterOfYearDateTimeField() {
        super("quarterOfYear");
    }

    public DurationFieldType getDurationType() {
        return QUARTER_OF_YEAR_DURATION_FIELD_TYPE;
    }

    public DurationFieldType getRangeDurationType() {
        return DurationFieldType.years();
    }

    public DateTimeField getField(Chronology chronology) {
        return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), QUARTER_OF_YEAR, 3), 1);
    }

    private static class QuarterOfYearDurationFieldType
    extends DurationFieldType {
        private static final long serialVersionUID = -8167713675442491871L;

        public QuarterOfYearDurationFieldType() {
            super("quarters");
        }

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.months(), QUARTER_OF_YEAR_DURATION_FIELD_TYPE, 3);
        }
    }
}

